/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.common.Utils;

public class ActionGetContractFreeSumma
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Contract contract = ContractDao.getContract(this.con, this.cid);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + this.cid + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        BalanceUtils bu = new BalanceUtils(this.con);
        Element row = this.createElement(this.rootNode, "free");
        if (contract.getBalanceMode() == 0) {
            row.setAttribute("amount", Utils.formatBigDecimalSumm((BigDecimal)bu.getSaldo(new Date(), contract.getId())));
        } else {
            row.setAttribute("amount", Utils.formatBigDecimalSumm((BigDecimal)bu.getBalance(LocalDate.now(), contract.getId())));
        }
        bu.close();
    }
}

