/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionKit;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPayment;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPaymentStatus;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonOptionKitDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonPaymentDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonProductDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.megafon.common.service.MegafonService")
public class MegafonServiceImpl
extends AbstractService
implements MegafonService {
    private MegafonProductDao productDao;
    private MegafonOptionDao optionDao;
    private MegafonOptionKitDao optionKitDao;
    private MegafonPaymentDao megafonPaymentDao;

    @PostConstruct
    public void init() {
        this.productDao = new MegafonProductDao(this.getConnection(), this.moduleId);
        this.optionDao = new MegafonOptionDao(this.getConnection(), this.moduleId);
        this.optionKitDao = new MegafonOptionKitDao(this.getConnection(), this.moduleId);
        this.megafonPaymentDao = new MegafonPaymentDao(this.getConnection(), this.moduleId);
    }

    public List<MegafonProduct> getProductList() throws Exception {
        return this.productDao.list("", "", new Object[0]);
    }

    public MegafonProduct getProduct(int productId) throws Exception {
        return (MegafonProduct)this.productDao.get(productId);
    }

    public void updateProduct(MegafonProduct product) throws Exception {
        this.productDao.update(product);
    }

    public void deleteProduct(int productId) throws Exception {
        if (((MegafonContractService)this.context.getService(MegafonContractService.class, this.context.getModuleId())).checkActiveProductOnContracts(productId)) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442, \u0442.\u043a. \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
        }
        this.productDao.delete(productId);
    }

    public List<MegafonOption> getOptionList() throws Exception {
        return this.optionDao.list("", "", new Object[0]);
    }

    public MegafonOption getMegafonOption(int optionId) throws Exception {
        return (MegafonOption)this.optionDao.get(optionId);
    }

    public void updateOption(MegafonOption option) throws Exception {
        this.optionDao.update(option);
    }

    public void deleteOption(int optionId) throws Exception {
        this.optionDao.delete(optionId);
    }

    public List<MegafonOptionKit> getOptionKitList() throws Exception {
        return this.optionKitDao.list("", "", new Object[0]);
    }

    public void updateOptionKit(MegafonOptionKit optionKit) throws Exception {
        this.optionKitDao.update(optionKit);
    }

    public MegafonOptionKit getOptionKit(int optionKitId) throws Exception {
        return (MegafonOptionKit)this.optionKitDao.get(optionKitId);
    }

    public void deleteOptionKit(int optionKitId) throws Exception {
        this.optionKitDao.delete(optionKitId);
    }

    public SearchResult<MegafonPayment> getMegafonPayments(Page page, LocalDate dateFrom, LocalDate dateTo) throws Exception {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setPeriod(new Period(dateFrom, dateTo));
        this.megafonPaymentDao.list((SearchResult<MegafonPayment>)searchResult);
        return searchResult;
    }

    public void updateMegafonPayment(MegafonPayment payment) throws Exception {
        this.megafonPaymentDao.update(payment);
    }

    public void cancelPayment(MegafonPayment payment) throws Exception {
        int paybackTypeId = this.getModuleSetup().getInt("cancelPayment.paybackType", 0);
        if (paybackTypeId <= 0) {
            throw new BGException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430!");
        }
        MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(this.moduleId);
        if (!kassaApiClient.cancelPayment(payment)) {
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u043d\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430!");
        }
        payment.setStatus(MegafonPaymentStatus.CANCEL);
        this.megafonPaymentDao.update(payment);
        ChargeService chargeService = (ChargeService)this.context.getService(ChargeService.class, 0);
        chargeService.chargeUpdate(new Charge().setPayback(true).setContractId(payment.getContractId()).setDate(new Date()).setComment("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u041c\u0435\u0433\u0430\u0444\u043e\u043d\u0430. paymentId=" + payment.getId()).setSum(payment.getAmount()).setTypeId(paybackTypeId).setUserId(0));
    }
}

