/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.accounts;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGSummaTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.bill.common.bean.accounts.BillAccountsReceivableDetail;
import ru.bitel.bgbilling.modules.bill.common.bean.accounts.BillAccountsReceivableDetailOnDate;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class BillAccountsReceivablePanel
extends BGUPanel {
    private JLabel countLabel = new JLabel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();
    private BGControlPanelDateNoB onDate = new BGControlPanelDateNoB();
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("BillAccountsReceivable");
    private BGSummaTextField totalSum = new BGSummaTextField();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 3, 0, 3), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
        this.add(this.getBottomPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 3, 3, 3), 0, 0));
    }

    private JPanel getTopPanel() {
        JButton nowButton = new JButton("\u043d\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f");
        nowButton.addActionListener(e -> this.onDate.setLocalDate(LocalDate.now()));
        JButton doButton = new JButton("\u0432\u044b\u0432\u0435\u0441\u0442\u0438");
        doButton.addActionListener(e -> {
            if (this.onDate.getLocalDate() == null) {
                ClientUtils.showMessageDialog((Object)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                return;
            }
            this.panelPages.reset();
            this.performAction("refresh");
        });
        this.panelPages.addToHandler(a -> this.performAction("refresh"));
        this.onDate.setLocalDate(LocalDate.now());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.onDate, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)nowButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)doButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.countLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleRMouseClicked((Component)table, e -> this.showTablePopupMenu((MouseEvent)e, (JTable)table, this.getPopupMenu()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0418\u0442\u043e\u0433\u043e:"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.totalSum, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected void getPopupMenuItems() {
        this.popupMenu.add("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f").addActionListener(e -> this.showDetail());
        this.popupMenu.addSeparator();
        this.popupMenu.add("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440").addActionListener(e -> this.openContract());
    }

    private void showDetail() {
        this.tableModel.optSelectedRow().ifPresent(a -> a.optValue("contractId").ifPresent(contractId -> new BillAccountsReceivableDialog((ClientContext)this.getContext(), Utils.parseInt((String)contractId)).showDialog()));
    }

    private void openContract() {
        this.tableModel.optSelectedRow().ifPresent(a -> a.optValue("contractId").ifPresent(contractId -> BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt((String)contractId))));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams().setPage(this.panelPages.getPage());
            Optional.ofNullable(this.onDate.getLocalDate()).ifPresent(a -> tableParams.addParam("onDate", a.toString()));
            this.tableModel.loadData((ClientContext)this.getContext(), tableParams, this.panelPages, this.countLabel);
            this.totalSum.setText(this.tableModel.getAttribute("totalSum"));
        });
    }

    class BillAccountsReceivableDialog
    extends BGDialog {
        private int contractId;
        private List<BGUTable> tables;

        public BillAccountsReceivableDialog(ClientContext context, int contractId) {
            super(context);
            this.contractId = 0;
            this.tables = new ArrayList<BGUTable>();
            this.contractId = contractId;
            this.setResizable(false);
            this.setTitle("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
            this.setDefaultCloseOperation(2);
            this.setSize(1000, 600);
            BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)new JScrollPane(this.getDateListPanel()), (Component)new JPanel(new GridBagLayout()), 450L);
            this.panel.add((Component)splitPane, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.moveWindowToCenterScreen();
        }

        private JPanel getDateListPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(Color.WHITE);
            panel.setOpaque(true);
            panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            BillAccountsReceivablePanel.this.tryCall(() -> {
                BillAccountsReceivableDetail receivableDetail = ((BillService)this.getContext().getWebService(BillService.class)).billAccountsReceivableDetail(this.contractId, BillAccountsReceivablePanel.this.onDate.getLocalDate());
                for (BillAccountsReceivableDetailOnDate onDate : receivableDetail.getDetailOnDates()) {
                    JLabel onDateLabel = new JLabel(TimeUtils.format((LocalDate)onDate.getDate(), (String)"dd.MM.yyyy"));
                    onDateLabel.setHorizontalAlignment(0);
                    onDateLabel.setFont(onDateLabel.getFont().deriveFont(1, 18.0f));
                    onDateLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    JLabel onDateSaldoIn = new JLabel("\u0412\u0445: " + Utils.formatCostByGrouping((BigDecimal)onDate.getSaldoIn(), (int)3, (int)2));
                    onDateSaldoIn.setHorizontalAlignment(0);
                    JLabel onDateSaldoOut = new JLabel("\u0418\u0441\u0445: " + Utils.formatCostByGrouping((BigDecimal)onDate.getSaldoOut(), (int)3, (int)2));
                    onDateSaldoOut.setHorizontalAlignment(0);
                    panel.add((Component)onDateLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
                    panel.add((Component)onDateSaldoIn, new GridBagConstraints(1, -1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                    panel.add((Component)onDateSaldoOut, new GridBagConstraints(2, -1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                    BGUTable table = this.getTable(onDate);
                    this.tables.add(table);
                    panel.add((Component)table.getTableHeader(), new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
                    panel.add((Component)table, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
                }
            });
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private BGUTable getTable(BillAccountsReceivableDetailOnDate onDate) {
            PaymentBillTableModel paymentBillTableModel = new PaymentBillTableModel();
            final BGUTable table = new BGUTable((TableModel)((Object)paymentBillTableModel));
            table.setRowSelectionAllowed(false);
            table.setCellSelectionEnabled(true);
            table.setSelectionMode(0);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    int c = table.columnAtPoint(event.getPoint());
                    int r = table.rowAtPoint(event.getPoint());
                    table.setRowSelectionInterval(r, r);
                    table.setColumnSelectionInterval(c, c);
                    for (BGUTable t : BillAccountsReceivableDialog.this.tables) {
                        if (t == table) continue;
                        t.clearSelection();
                    }
                }
            });
            paymentBillTableModel.setData(Arrays.asList(new PaymentBillData().setPaymentSum(new BigDecimal("1023.34")).setBillDocumentSum(new BigDecimal("123.00")), new PaymentBillData().setPaymentSum(new BigDecimal("1023.34")).setBillDocumentSum(new BigDecimal("123.00"))));
            return table;
        }
    }

    public static class PaymentBillData {
        private int paymentId;
        private BigDecimal paymentSum;
        private int billDocumentId;
        private BigDecimal billDocumentSum;

        public int getPaymentId() {
            return this.paymentId;
        }

        public BigDecimal getPaymentSum() {
            return this.paymentSum;
        }

        public int getBillDocumentId() {
            return this.billDocumentId;
        }

        public BigDecimal getBillDocumentSum() {
            return this.billDocumentSum;
        }

        public PaymentBillData setPaymentId(int paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public PaymentBillData setPaymentSum(BigDecimal paymentSum) {
            this.paymentSum = paymentSum;
            return this;
        }

        public PaymentBillData setBillDocumentId(int billDocumentId) {
            this.billDocumentId = billDocumentId;
            return this;
        }

        public PaymentBillData setBillDocumentSum(BigDecimal billDocumentSum) {
            this.billDocumentSum = billDocumentSum;
            return this;
        }
    }

    static class PaymentBillTableModel
    extends BGTableModel<PaymentBillData> {
        public PaymentBillTableModel() {
            super(PaymentBillTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0440\u0438\u0445\u043e\u0434", 150, 180, -1, "paymentSum", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0447\u0435\u0442", 150, 180, -1, "billDocumentSum", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }
    }
}

