/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server.event.worker;

import java.math.BigDecimal;
import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class GazprombankAutopaymentEventWorker
extends EventWorker {
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private long sleepTimeout = 500L;

    public GazprombankAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), GazprombankAutopaymentEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.sleepTimeout = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getLong("gazprombank.autopayment.event.worker.sleep.timeout", 500L);
        this.getLogger().info("Starting GazprombankAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "gazprombank-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        GazprombankAutopaymentEvent event = (GazprombankAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        try {
            Contract contract;
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = ContractDao.getContract((Connection)((EventListenerContext)this.context).getConnection(), (int)contractId)) != null) {
                this.transactionManager.doAutopayment(contractId, contract.getTitle(), sum, autopayment);
                try {
                    Thread.sleep(this.sleepTimeout);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return null;
    }
}

