/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.updater.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTaskLog;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTaskLogStatus;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class UpdaterTaskLogDao
extends AbstractDao<UpdaterTaskLog> {
    public UpdaterTaskLogDao(Connection con) {
        super(con, "updater_task_log");
    }

    public List<UpdaterTaskLog> getUpdaterTaskLogList(int taskId) throws BGException {
        return this.list("task_id=?", "run_date DESC", taskId);
    }

    public String getUpdaterTaskLog(int updateTaskLogId) throws BGException {
        String data = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT data FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, updateTaskLogId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                data = rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return data;
    }

    public void setUpdaterTaskLog(int updateTaskLogId, String data) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET data=? WHERE id=?");
            ps.setString(1, data);
            ps.setInt(2, updateTaskLogId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    protected UpdaterTaskLog getFromRS(ResultSet rs) throws SQLException, BGException {
        UpdaterTaskLog updaterTaskLog = new UpdaterTaskLog();
        updaterTaskLog.setId(rs.getInt("id"));
        updaterTaskLog.setTaskId(rs.getInt("task_id"));
        updaterTaskLog.setRunDate(rs.getTimestamp("run_date"));
        updaterTaskLog.setStatus(UpdaterTaskLogStatus.valueOf(rs.getString("status")));
        updaterTaskLog.setUserId(rs.getInt("user_id"));
        return updaterTaskLog;
    }

    @Override
    protected void updateImpl(UpdaterTaskLog updaterTaskLog) throws BGException, SQLException {
        Objects.requireNonNull(updaterTaskLog);
        try {
            int index = 1;
            boolean insert = updaterTaskLog.getId() < 1;
            String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET task_id=?, run_date=?, status=?, user_id=?" + (insert ? "" : " WHERE id=?");
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(index++, updaterTaskLog.getTaskId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp(updaterTaskLog.getRunDate()));
                ps.setString(index++, updaterTaskLog.getStatus().name());
                ps.setInt(index++, updaterTaskLog.getUserId());
                if (!insert) {
                    ps.setInt(index++, updaterTaskLog.getId());
                }
                ps.executeUpdate();
                if (insert) {
                    updaterTaskLog.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }
}

