/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public final class XPlatTransactionManager
extends MPSTransactionManager {
    private static final String encoding = "windows-1251";
    private static final String TIMEPATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Pattern responsePattern = Pattern.compile("<response>(.*)</response>", 32);
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(\\d+)\\t(\\d+\\.*\\d*)\\t(.+)\\t([\\d+\\.: -]+)\\t(.+)$", 8);

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), new Date());
                    if (transaction != null) {
                        if (transaction.getStatus().equals(TransactionStatus.PAYMENT_NOT_PAYED.getCode())) break;
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u0443\u0436\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
                    }
                    transaction = this.prepareTransaction(con, moduleId, mpsId, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType());
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), new Date());
                    if (transaction == null) {
                        mpsResponse.setResult(100);
                        mpsResponse.setMessage("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                        break;
                    }
                    Contract contract = this.getContractById(con, transaction.getContractId());
                    if (transaction.getStatus().equals(TransactionStatus.PAYMENT_NOT_PAYED.getCode())) {
                        if (contract == null) {
                            throw new MPSException(3, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        }
                        this.checkTime(mpsRequest);
                        transaction = this.executePreparedTransaction(con, moduleId, system, transaction, system.title);
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    break;
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        mpsRequest.setNumber(request.getParameter("account"));
        mpsRequest.setRawNumber(mpsRequest.getNumber());
        mpsRequest.setType(Utils.parseInt((String)request.getParameter("type"), (int)-1));
        String summString = request.getParameter("amount");
        mpsRequest.setSum(Utils.parseBigDecimal((String)summString, (BigDecimal)BigDecimal.ZERO));
        mpsRequest.setTransId(request.getParameter("pt_id"));
        String timeString = request.getParameter("post_date");
        mpsRequest.setTime(TimeUtils.parseDate((String)timeString, (String)TIMEPATTERN));
        String reqHash = request.getParameter("md5_digest");
        if (mpsRequest.getTime() == null && (mpsRequest.getSum() == null || mpsRequest.getSum().compareTo(BigDecimal.ZERO) == 0)) {
            mpsRequest.setAction(2);
        } else {
            mpsRequest.setAction(1);
        }
        switch (mpsRequest.getAction()) {
            case 1: {
                StringBuilder sb = new StringBuilder(20);
                sb.append(mpsRequest.getTransId());
                sb.append(summString);
                sb.append(timeString);
                sb.append(mpsRequest.getNumber());
                if (mpsRequest.getType() >= 0) {
                    sb.append(mpsRequest.getType());
                }
                sb.append(system.secret);
                String hash = Utils.getDigest((String)sb.toString(), (String)this.getEncoding());
                if (hash.equalsIgnoreCase(reqHash)) break;
                throw new MPSException(10);
            }
            case 2: {
                StringBuilder sb = new StringBuilder(20);
                sb.append(mpsRequest.getTransId());
                sb.append(system.secret);
                String hash = Utils.getDigest((String)sb.toString(), (String)this.getEncoding());
                if (hash.equalsIgnoreCase(reqHash)) break;
                throw new MPSException(10);
            }
        }
        return mpsRequest;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(10);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(90);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(100);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(100);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(100);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(100);
                response.setMessage(ex.message);
                break;
            }
            case 10: {
                response.setResult(20);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(220);
                response.setMessage(ex.message);
                break;
            }
            case 20: {
                response.setResult(100);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        switch (req.getAction()) {
            case 1: {
                if (req.getNumber() != null && req.getNumber().length() > 0 && req.getSum() != null && (system.extDontCheckSum || req.getSum().compareTo(BigDecimal.ZERO) > 0) && req.getTransId() != null && this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) > 0) break;
                throw new MPSException(2);
            }
            case 2: {
                if (req.getTransId() != null && this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) > 0) break;
                throw new MPSException(2);
            }
        }
        super.checkValid(system, req, con);
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element rootNodeXml = XMLUtils.createElement((Document)doc, (String)"xml");
        Element rootNode = XMLUtils.createElement((Element)rootNodeXml, (String)"response");
        Element result = XMLUtils.createElement((Element)rootNode, (String)"error");
        result.setAttribute("code", String.valueOf(response.getResult()));
        if (response.getMessage() != null) {
            result.setTextContent(response.getMessage());
        }
        XMLUtils.createElement((Element)rootNode, (String)"pt_id").setTextContent(response.getTransId());
        if (response.getAction() > 0) {
            XMLUtils.createElement((Element)rootNode, (String)"provider_tran_id").setTextContent(String.valueOf(response.getId()));
        }
        try {
            Matcher m = responsePattern.matcher(XMLUtils.serializeToString((Node)doc, (boolean)false));
            if (m.find()) {
                String hash = Utils.getDigest((String)(m.group(1) + system.secretResponse), (String)encoding);
                XMLUtils.createElement((Element)rootNodeXml, (String)"md5_digest").setTextContent(hash);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("error serialize xml / get digest", (Throwable)ex);
        }
        return this.xmlSerialize(doc);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = TRANSACTION_PATTERN.matcher(file);
        while (match.find()) {
            char type;
            Date time = TimeUtils.parseDate((String)match.group(4), (String)"dd.MM.yyyy HH:mm:ss");
            if (time == null) {
                System.out.println(match.group(4));
                time = TimeUtils.parseDate((String)match.group(4), (String)"yyyy-MM-dd HH:mm:ss.SSS");
                System.out.println(time);
            }
            String number = match.group(3);
            Transaction transaction = new Transaction().setId(Utils.parseInt((String)match.group(5), (int)0)).setTransId(Utils.parseLong((String)match.group(1), (long)0L)).setTime(time).setRawNumber(number).setSum(Utils.parseBigDecimal((String)match.group(2), (BigDecimal)BigDecimal.ZERO)).setStatus(TransactionStatus.PAYMENT_PAYED.getCode());
            if (system.osmpPrefix && number != null && number.length() > 1 && number.charAt(1) == '_' && Character.isDigit((int)(type = number.charAt(0)))) {
                transaction.setType(Character.getNumericValue((int)type));
                transaction.setNumber(number.substring(2));
            } else {
                transaction.setNumber(number);
            }
            result.add(transaction);
        }
        return result;
    }

    private class ErrorCode {
        private static final int ANSWER_SUCCESS = 0;
        private static final int ANSWER_ERR_REQUEST = 10;
        private static final int ANSWER_ERR_HASH = 20;
        protected static final int ANSWER_ERR_NOT_VALID_PTID = 50;
        private static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 90;
        private static final int ANSWER_ERR_UNKNOWN = 100;
        private static final int ANSWER_ERR_SERVER = 100;
        private static final int ANSWER_ERR_PAYMENT = 220;

        private ErrorCode(XPlatTransactionManager xPlatTransactionManager) {
        }
    }
}

