/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSelectFilePanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.mps.client.TransactionPanel;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;

public class TransactionMonitor
extends TransactionPanel {
    public TransactionMonitor() {
        this.transactionModel = new TransactionTableModel(TransactionMonitor.class.getName());
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        super.initPopupListener();
    }

    protected JPanel getExtraBottomPanel() {
        BGSelectFilePanel selectFile = new BGSelectFilePanel(true);
        selectFile.setMinimumSize(new Dimension(500, 0));
        selectFile.setPreferredSize(new Dimension(500, 0));
        BGButton saveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        saveButton.addActionListener(e -> {
            if (selectFile.getSelectedFile() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f!");
                return;
            }
            this.saveData(selectFile.getSelectedFile().getAbsolutePath());
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)selectFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)saveButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 50), 0, 0));
        return panel;
    }

    protected void initPopupMenu() {
        this.getTable().getPopupMenu().add(this.getOpenContractMenuItem());
    }

    public void saveData(String path) {
        KeyValue item;
        File file;
        if (!((String)path).endsWith(".csv") && !((String)path).endsWith(".CSV")) {
            path = (String)path + ".csv";
        }
        if ((file = new File((String)path)).exists() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b " + file.getName() + " \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) != 0) {
            return;
        }
        Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId()).setAction("PaymentList").setPage(this.pagePanel).setPeriod(this.periodPanel.getPeriod()).setAttribute("contentType", "text/csv");
        AbstractTransactionStatus status = (AbstractTransactionStatus)this.statusComboBox.getSelectedItem();
        if (status != null) {
            request.setAttribute("type", status.getCode());
        }
        if ((item = (KeyValue)this.systemComboBox.getSelectedItem()) != null) {
            request.setAttribute("system", item.getKey());
        }
        String f = TransferManager.getString((Request)request);
        try (FileWriter fw = new FileWriter((String)path);){
            fw.append(f);
            fw.flush();
        }
        catch (IOException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class TransactionTableModel
    extends ru.bitel.bgbilling.modules.mps.client.TransactionTableModel {
        public TransactionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430", 40, 160, 200, "mpsId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u041f\u0421", 40, 160, -1, "transId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 40, 100, -1, "rawNumber", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f (\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 \u041f\u0421)", 180, 180, 180, "time", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
            this.addColumnContractTitle();
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 150, 150, -1, "contractComment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnStatus();
            this.addColumnSum();
        }

        public Object getValueAt(Transaction val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("mpsId".equals(identifier)) {
                return TransactionMonitor.this.systemItems.stream().filter(a -> a.getKey().equals(val.getMpsId())).map(a -> a.getValue()).findFirst().orElse("??? [#" + val.getMpsId() + "]");
            }
            return super.getValueAt((Object)val, column);
        }
    }
}

