/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

class SaveTemplateDialog
extends JDialog {
    private SQLEditor sqlEditor;
    private JTextField templateName = new JTextField(40);
    private JCheckBox allCheckBox = new JCheckBox("\u0412\u0438\u0434\u0438\u043c \u0434\u043b\u044f \u0432\u0441\u0435\u0445");

    SaveTemplateDialog(SQLEditor sqlEditor) {
        super(JOptionPane.getRootFrame());
        this.sqlEditor = sqlEditor;
        this.setTitle("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
        this.setModal(true);
        this.setResizable(false);
        BGButtonPanelOkCancel panelOkCancel = new BGButtonPanelOkCancel();
        panelOkCancel.addActionListener(event -> {
            String actionCommand = event.getActionCommand();
            if ("ok".equals(actionCommand)) {
                try {
                    this.saveSQLTemplate();
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            } else if ("cancel".equals(actionCommand)) {
                this.close();
            }
        });
        int gridy = 0;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 0, 10), 0, 0));
        container.add((Component)this.templateName, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 10, 0, 10), 0, 0));
        container.add((Component)this.allCheckBox, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 10, 0, 10), 0, 0));
        container.add((Component)panelOkCancel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getRootFrame());
    }

    public void setTemplateTitle(String title) {
        this.templateName.setText(title);
    }

    public void setAllSee(boolean value) {
        this.allCheckBox.setSelected(value);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void saveSQLTemplate() throws BGException {
        if (Utils.isEmptyString((String)this.templateName.getText())) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430!");
            return;
        }
        this.sqlEditor.getSqlEditorService().templateUpdate(this.templateName.getText(), this.sqlEditor.getQuery().getText(), this.allCheckBox.isSelected());
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
        this.sqlEditor.listSQLTemplate();
        this.close();
    }
}

