/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public class BalanceTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TvTariffContext, TreeContext, TvTariffWorkerContext> {
    public static final int MODE_GREATER_OR_EQUAL = 0;
    public static final int MODE_LESS = 1;
    private final int mode;
    private final BigDecimal delta;

    public BalanceTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.mode = parameterMap.getInt("mode", 0);
        BigDecimal delta = parameterMap.getBigDecimal("delta", null);
        if (delta != null && BigDecimal.ZERO.compareTo(delta) == 0) {
            delta = null;
        }
        this.delta = delta;
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TvTariffContext context, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        BigDecimal balance = req.getBalance();
        BigDecimal limit = req.getLimit();
        if (balance == null || limit == null) {
            return 0;
        }
        boolean isBalanceExceeds = this.delta != null ? balance.subtract(this.delta).compareTo(limit) >= 0 : balance.compareTo(limit) >= 0;
        switch (this.mode) {
            case 1: {
                return isBalanceExceeds ? 0 : 1;
            }
        }
        return isBalanceExceeds ? 1 : 0;
    }
}

