/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cticas4;

import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;

public class ByteDeserializer {
    private byte[] buffer = null;
    private int pos = 0;

    public ByteDeserializer(byte[] buffer) {
        this.buffer = buffer;
    }

    public long getLong(int fieldlen) {
        long result = 0L;
        for (int i = 0; i < fieldlen; ++i) {
            long b = (long)this.buffer[this.pos + fieldlen - i - 1] & 0xFFL;
            result |= b << 8 * i;
        }
        this.pos += fieldlen;
        return result;
    }

    public int getInt(int fieldlen) {
        return (int)this.getLong(fieldlen);
    }

    public byte getByte(int fieldlen) {
        return (byte)this.getLong(fieldlen);
    }

    public String getString(int fieldlen) {
        return new String(this.getBytes(fieldlen), StandardCharsets.UTF_8);
    }

    public byte[] getBytes(int fieldlen) {
        byte[] result = new byte[fieldlen];
        System.arraycopy(this.buffer, this.pos, result, 0, result.length);
        this.pos += result.length;
        return result;
    }

    public Date getSTMP() {
        int YEAR = this.getInt(2);
        int MONTH = this.getInt(1);
        int DAY_OF_MONTH = this.getInt(1);
        int HOUR_OF_DAY = this.getInt(1);
        int MINUTE = this.getInt(1);
        int SECOND = this.getInt(1);
        Calendar cal = Calendar.getInstance();
        cal.set(1, YEAR);
        cal.set(2, MONTH - 1);
        cal.set(5, DAY_OF_MONTH);
        cal.set(11, HOUR_OF_DAY);
        cal.set(12, MINUTE);
        cal.set(13, SECOND);
        return cal.getTime();
    }

    public int available() {
        return this.buffer.length - this.pos;
    }
}

