/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptLibrary;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptBackupManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class ScriptLibraryManager
extends AbstractIdDao<ScriptLibrary> {
    public ScriptLibraryManager(Connection con) {
        super(con, "script_lib");
    }

    protected void updateImpl(ScriptLibrary scriptLibrary) throws SQLException {
        String querySet = "name=?, title=?, script=?, user_id=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)scriptLibrary, querySet);){
            int index = 1;
            ps.setString(index++, scriptLibrary.getName());
            ps.setString(index++, scriptLibrary.getTitle());
            ps.setString(index++, scriptLibrary.getScript());
            ps.setInt(index++, scriptLibrary.getUserId());
            this.executeUpdate((Id)scriptLibrary, index, ps);
            scriptLibrary.setTimeRevision(((ScriptLibrary)this.get(scriptLibrary.getId())).getTimeRevision());
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().startsWith("23")) {
                throw new SQLException("\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            throw e;
        }
    }

    public ScriptLibrary getByName(String name) throws SQLException {
        String query = "SELECT * FROM " + this.tableName + " WHERE name=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    ScriptLibrary scriptLibrary = this.getFromRS(rs);
                    return scriptLibrary;
                }
            }
        }
        return null;
    }

    public List<ScriptLibrary> list() throws SQLException {
        return super.list(null, "title", new Object[0]);
    }

    public List<ScriptLibrary> pureList() throws SQLException {
        ArrayList<ScriptLibrary> result = new ArrayList<ScriptLibrary>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getPureFromRS(rs));
                }
            }
            ArrayList<ScriptLibrary> arrayList = result;
            return arrayList;
        }
    }

    protected ScriptLibrary getFromRS(ResultSet rs) throws SQLException {
        ScriptLibrary result = new ScriptLibrary();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        result.setScript(rs.getString("script"));
        result.setUserId(rs.getInt("user_id"));
        result.setTimeRevision(rs.getTimestamp("change_time"));
        return result;
    }

    protected ScriptLibrary getPureFromRS(ResultSet rs) throws SQLException {
        ScriptLibrary result = new ScriptLibrary();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        result.setScript("");
        result.setUserId(rs.getInt("user_id"));
        result.setTimeRevision(rs.getTimestamp("change_time"));
        return result;
    }

    public Revision getRevisionProperties(int id) throws SQLException {
        String query = "SELECT id, user_id, change_time FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Revision result = null;
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = new Revision();
                    result.setId(rs.getInt("id"));
                    result.setUserId(rs.getInt("user_id"));
                    result.setUserName(UserMap.getUser(result.getUserId()).getName());
                    result.setTimeRevision(rs.getTimestamp("change_time"));
                }
            }
            Revision revision = result;
            return revision;
        }
    }

    public void backup(int scriptId, String comment) throws Exception {
        ScriptBackup backup = new ScriptBackup();
        backup.setScriptBackup((Script)this.get(scriptId), 2);
        backup.setComment(comment);
        backup.setId(-1);
        new ScriptBackupManager(this.con).update((Object)backup);
    }

    public void deleteFull(int scriptId) throws Exception {
        this.delete(scriptId);
        new ScriptBackupManager(this.con).deleteBackups(scriptId, 2);
    }
}

