/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common.model;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.ListItem;

public class BGUListItem
extends IdTitle
implements ListItem {
    private boolean selected = false;
    private final Map<String, Object> attr = new HashMap<String, Object>();

    public BGUListItem() {
    }

    public BGUListItem(int id, String title) {
        super(id, title);
        this.setAttribute("id", String.valueOf(id));
        this.setAttribute("title", title);
    }

    public BGUListItem(IdTitle idTitle) {
        this(idTitle.getId(), idTitle.getTitle());
    }

    public BGUListItem(int id, String title, boolean selected) {
        this(id, title);
        this.selected = selected;
    }

    public BGUListItem(String id, String title) {
        super(Utils.parseInt(id), title);
        this.setAttribute("id", id);
        this.setAttribute("title", title);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void invertSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public BGUListItem setAttribute(String key, Object obj) {
        if (key != null && obj != null) {
            this.attr.put(key, obj);
        }
        return this;
    }

    public Object getAttribute(String key) {
        return key == null ? null : this.attr.get(key);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    public String getIdStr() {
        Object id = this.getAttribute("id");
        if (id == null || Utils.isBlankString(id.toString())) {
            id = this.getId();
        }
        return id.toString();
    }
}

