/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.server;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.CachedServerDirectoryView;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryInfo;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryView;
import ru.bitel.bgbilling.kernel.directory.api.server.UnmodifiableServerDirectoryView;
import ru.bitel.common.model.Id;

public class ServerDirectoryFactory {
    public static <K extends Id> Directory<K> newUnmodifiableDirectory(Class<K> clazz, Connection con, int moduleId, boolean cached) throws BGException {
        try {
            ServerDirectoryInfo<K> info = ServerDirectoryInfo.getInstance(clazz);
            Directory<K> dao = info.newDao(con, moduleId);
            return new UnmodifiableServerDirectoryView<K>(info, moduleId, dao, cached);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public static <K extends Id> Directory<K> newDirectory(ServerContext context, Class<K> clazz, Connection con, int moduleId, boolean cached) throws BGException {
        try {
            ServerDirectoryInfo<K> info = ServerDirectoryInfo.getInstance(clazz);
            Directory<K> dao = info.newDao(con, moduleId);
            if (cached) {
                return new CachedServerDirectoryView<K>(context, info, moduleId, dao, cached);
            }
            return new ServerDirectoryView<K>(context, info, moduleId, dao);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public static long getVersion(Class<? extends Id> directoryItemClass, int moduleId) throws BGException {
        return ServerDirectoryInfo.getInstance(directoryItemClass).getCacheVersion(moduleId);
    }
}

