/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanOperation;

public class AnnotatedMBean
extends BGLogger
implements DynamicMBean {
    private final Object bean;
    private final SortedMap<String, MBeanAttributeEntry> attributeMap;
    private final SortedMap<String, MBeanOperationEntry> operationMap;

    public AnnotatedMBean(Object bean, SortedMap<String, MBeanAttributeEntry> attributeMap, SortedMap<String, MBeanOperationEntry> operationMap) {
        this.bean = bean;
        this.attributeMap = attributeMap;
        this.operationMap = operationMap;
    }

    public static AnnotatedMBean newInstance(Object o) {
        MBeanAttributeEntry attribute;
        Object name;
        boolean setter;
        boolean getter;
        Class<?> clazz = o.getClass();
        TreeMap<String, MBeanAttributeEntry> attributeMap = new TreeMap<String, MBeanAttributeEntry>();
        TreeMap<String, MBeanOperationEntry> operationMap = new TreeMap<String, MBeanOperationEntry>();
        Set<Method> methodList = Collections.newSetFromMap(new LinkedHashMap());
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            for (GenericDeclaration genericDeclaration : clazz2.getInterfaces()) {
                methodList.addAll(Arrays.asList(((Class)genericDeclaration).getMethods()));
            }
            methodList.addAll(Arrays.asList(clazz2.getMethods()));
        }
        for (Method method : methodList) {
            MBeanOperation mBeanOperation = method.getAnnotation(MBeanOperation.class);
            if (mBeanOperation != null) {
                MBeanOperationEntry mBeanOperationEntry = new MBeanOperationEntry();
                mBeanOperationEntry.method = method;
                mBeanOperationEntry.description = mBeanOperation.description();
                operationMap.put(method.getName(), mBeanOperationEntry);
                continue;
            }
            MBeanAttribute mBeanAttribute = method.getAnnotation(MBeanAttribute.class);
            if (mBeanAttribute == null) continue;
            getter = false;
            setter = false;
            name = method.getName();
            if (((String)name).startsWith("get") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3)) && method.getParameterTypes().length == 0) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                getter = true;
            } else if (((String)name).startsWith("is") && Character.isUpperCase(((String)name).codePointAt(2)) && method.getParameterTypes().length == 0) {
                name = ((String)name).substring(2, 3).toLowerCase() + ((String)name).substring(3);
                getter = true;
            } else if (method.getReturnType() != Void.class && method.getParameterTypes().length == 0) {
                getter = true;
            } else if (((String)name).startsWith("set") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3))) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                setter = true;
            } else if (method.getReturnType() == Void.class && method.getParameterTypes().length == 1) {
                setter = true;
            }
            if (!getter && !setter) continue;
            attribute = (MBeanAttributeEntry)attributeMap.get(name);
            if (attribute == null) {
                attribute = new MBeanAttributeEntry();
                attribute.name = name;
                attributeMap.put((String)name, attribute);
            }
            if (getter) {
                attribute.getter = method;
            } else {
                attribute.setter = method;
            }
            if (!Utils.isBlankString(attribute.description)) continue;
            attribute.description = mBeanAttribute.description();
        }
        for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
            getter = false;
            setter = false;
            name = ((Method)genericDeclaration).getName();
            if (((String)name).startsWith("get") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3))) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                getter = true;
            } else if (((String)name).startsWith("is") && ((String)name).length() > 2 && Character.isUpperCase(((String)name).codePointAt(2))) {
                name = ((String)name).substring(2, 3).toLowerCase() + ((String)name).substring(3);
                getter = true;
            } else if (((Method)genericDeclaration).getReturnType() != Void.class && ((Method)genericDeclaration).getParameterTypes().length == 0) {
                getter = true;
            } else if (((String)name).startsWith("set") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3))) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                setter = true;
            } else if (((Method)genericDeclaration).getReturnType() == Void.class && ((Method)genericDeclaration).getParameterTypes().length == 1) {
                setter = true;
            }
            if (!getter && !setter || (attribute = (MBeanAttributeEntry)attributeMap.get(name)) == null) continue;
            if (getter) {
                attribute.getter = genericDeclaration;
                continue;
            }
            attribute.setter = genericDeclaration;
        }
        for (AnnotatedElement annotatedElement : clazz.getFields()) {
            MBeanAttribute mBeanAttribute = ((Field)annotatedElement).getAnnotation(MBeanAttribute.class);
            if (mBeanAttribute == null) continue;
            MBeanAttributeEntry attribute2 = (MBeanAttributeEntry)attributeMap.get(((Field)annotatedElement).getName());
            if (attribute2 == null) {
                attribute2 = new MBeanAttributeEntry();
                attribute2.name = ((Field)annotatedElement).getName();
            }
            attribute2.field = annotatedElement;
            if (!Utils.isBlankString(attribute2.description)) continue;
            attribute2.description = mBeanAttribute.toString();
        }
        return new AnnotatedMBean(o, attributeMap, operationMap);
    }

    public static ObjectName register(Object annotatedBean) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return AnnotatedMBean.register(mBeanServer, annotatedBean);
    }

    public static ObjectName register(Object annotatedBean, String suffix) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return AnnotatedMBean.register(mBeanServer, annotatedBean, suffix, false);
    }

    public static ObjectName register(MBeanServer mBeanServer, Object annotatedBean) {
        return AnnotatedMBean.register(mBeanServer, annotatedBean, null, true);
    }

    public static void register(String objectName, Object annotatedBean) {
        try {
            AnnotatedMBean annotatedMBean = AnnotatedMBean.newInstance(annotatedBean);
            if (annotatedMBean.getAttributeMap().size() == 0 && annotatedMBean.getOperationMap().size() == 0) {
                return;
            }
            ObjectName objName = new ObjectName(objectName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(annotatedMBean, objName);
            new BGLogger(AnnotatedMBean.class).getLogger().info("Register MBean " + objectName);
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }

    private static ObjectName register(MBeanServer mBeanServer, Object annotatedBean, String name, boolean autoSuffix) {
        BGLogger logger = new BGLogger(AnnotatedMBean.class);
        try {
            AnnotatedMBean annotatedMBean = AnnotatedMBean.newInstance(annotatedBean);
            if (annotatedMBean.getAttributeMap().size() == 0 && annotatedMBean.getOperationMap().size() == 0) {
                return null;
            }
            Class<?> clazz = annotatedBean.getClass();
            logger.getLogger().debug("register: clazz={}", (Object)clazz.getName());
            Object type = clazz.getPackage().getName();
            type = Utils.isBlankString(clazz.getSimpleName()) ? (String)type + ":type=" + clazz.getName().substring(clazz.getPackage().getName().length() + 1) : (String)type + ":type=" + clazz.getSimpleName();
            logger.getLogger().debug("register: type={}", type);
            if (Utils.notBlankString(name)) {
                type = (String)type + "," + (String)(name.indexOf("=") > 0 ? name : "name=" + name);
            }
            logger.getLogger().debug("register: name={}; type={}", (Object)name, type);
            if (!autoSuffix) {
                ObjectName objectName = new ObjectName((String)type);
                logger.getLogger().info("Register MBean " + (String)type);
                mBeanServer.registerMBean(annotatedMBean, objectName);
                return objectName;
            }
            for (int i = 0; i < 100; ++i) {
                try {
                    ObjectName objectName = new ObjectName((String)type + (String)(i > 0 ? "-" + i : ""));
                    mBeanServer.registerMBean(annotatedMBean, objectName);
                    logger.getLogger().info("Register MBean " + (String)type);
                    return objectName;
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    continue;
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return null;
    }

    public SortedMap<String, MBeanAttributeEntry> getAttributeMap() {
        return this.attributeMap;
    }

    public SortedMap<String, MBeanOperationEntry> getOperationMap() {
        return this.operationMap;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeEntry a = (MBeanAttributeEntry)this.attributeMap.get(attribute);
        if (a == null) {
            throw new AttributeNotFoundException(attribute);
        }
        if (a.getter != null) {
            try {
                return a.getter.invoke(this.bean, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
        }
        if (a.field != null) {
            try {
                return a.field.get(this.bean);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MBeanAttributeEntry a = (MBeanAttributeEntry)this.attributeMap.get(attribute.getName());
        if (a == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        a.set(this.bean, attribute.getValue());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        for (Map.Entry<String, MBeanAttributeEntry> e : this.attributeMap.entrySet()) {
            try {
                result.add(new Attribute(e.getKey(), e.getValue().get(this.bean)));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        for (Attribute attribute : attributes.asList()) {
            try {
                MBeanAttributeEntry a = (MBeanAttributeEntry)this.attributeMap.get(attribute.getName());
                if (a == null) {
                    throw new AttributeNotFoundException(attribute.getName());
                }
                a.set(this.bean, attribute.getValue());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return attributes;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        MBeanOperationEntry operation = (MBeanOperationEntry)this.operationMap.get(actionName);
        if (operation == null) {
            throw new ReflectionException(new NoSuchMethodException(actionName));
        }
        try {
            return operation.method.invoke(this.bean, params);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Map.Entry<String, MBeanAttributeEntry> entry : this.attributeMap.entrySet()) {
            try {
                attributes.add(entry.getValue().toInfo());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.operationMap.entrySet()) {
            try {
                operations.add(((MBeanOperationEntry)entry.getValue()).toInfo());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        MBeanInfo result = new MBeanInfo(this.bean.getClass().getName(), "description", attributes.toArray(new MBeanAttributeInfo[attributes.size()]), new MBeanConstructorInfo[0], operations.toArray(new MBeanOperationInfo[operations.size()]), new MBeanNotificationInfo[0]);
        return result;
    }

    static class MBeanOperationEntry {
        Method method;
        String description;

        MBeanOperationEntry() {
        }

        public MBeanOperationInfo toInfo() {
            return new MBeanOperationInfo(this.description, this.method);
        }
    }

    static class MBeanAttributeEntry {
        String name;
        Method getter;
        Method setter;
        Field field;
        String description;

        MBeanAttributeEntry() {
        }

        public void set(Object bean, Object value) throws ReflectionException, AttributeNotFoundException {
            if (this.setter != null) {
                try {
                    this.setter.invoke(bean, value);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
            if (this.field != null) {
                try {
                    this.field.set(bean, value);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
            }
            throw new AttributeNotFoundException("Set attribute not supported for " + this.name);
        }

        public Object get(Object bean) throws AttributeNotFoundException, ReflectionException {
            if (this.getter != null) {
                try {
                    return this.getter.invoke(bean, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
            if (this.field != null) {
                try {
                    return this.field.get(bean);
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
            }
            throw new AttributeNotFoundException(this.name);
        }

        public MBeanAttributeInfo toInfo() {
            Class<?> type = this.getter != null ? this.getter.getReturnType() : this.field.getType();
            boolean isWritable = this.setter != null || this.field != null && (this.field.getModifiers() & 0x10) == 0;
            return new MBeanAttributeInfo(this.name, type.getName(), Utils.notEmptyString(this.description) ? this.description : this.name, true, isWritable, this.getter != null && this.getter.getName().startsWith("is"));
        }
    }
}

