/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.table;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.bill.common.bean.BillAccountsReceivable;
import ru.bitel.bgbilling.modules.bill.server.bean.BillAccountsReceivableManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class TableBillAccountsReceivable
extends BGTableInfoBase {
    public TableBillAccountsReceivable() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnDate((String)"\u0414\u0430\u0442\u0430", (String)"onDate"), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440", (String)"contractTitle").setPrefWidth(150).setMaxWidth(150), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", (String)"contractComment").setPrefWidth(500).setMaxWidth(500), BGUTableColumn.buildColumnTextLeft((String)"\u0417\u0430\u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e \u0441\u0447\u0435\u0442\u0443(\u0430\u043c)", (String)"bills").setWidth(-1), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0443\u043c\u043c\u0430 \u0437\u0430\u0434\u043e\u043b\u0436.", (String)"sum").setMaxWidth(150)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        DecimalFormat decimalFormat = Utils.getDecimalFormatSumma();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        if (tableParams == null || tableParams.getParams() == null) {
            return Collections.emptyList();
        }
        LocalDate onDate = LocalDate.parse(tableParams.optParamValue("onDate").orElse(LocalDate.now().toString()));
        SearchResult searchResult = new SearchResult(tableParams.getPage());
        new BillAccountsReceivableManager(serverContext.getConnection(), moduleId).searchBillAccountsReceivable((SearchResult<BillAccountsReceivable>)searchResult, onDate);
        this.page = searchResult.getPage();
        this.getAttributes().clear();
        this.addAttribute("totalSum", decimalFormat.format(searchResult.getSum()));
        return searchResult.getList().stream().map(a -> new BGUTableRowData().addValue("contractId", String.valueOf(a.getContractId())).addValue("contractTitle", a.getContractTitle()).addValue("contractComment", a.getContractComment()).addValue("onDate", Optional.ofNullable(a.getDate()).orElse(onDate).format(dateTimeFormatter)).addValue("sum", Optional.ofNullable(a.getSum()).map(b -> decimalFormat.format(b)).orElse("")).addValue("bills", a.getBills())).toList();
    }
}

