/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import bitel.billing.server.ActionConType;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@ActionConType(value=2)
public class ActionContractBill
extends ActionBase {
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Page page = this.getPage();
        DecimalFormat format = new DecimalFormat("00");
        BillManager pbm = new BillManager(this.conSlave, this.mid);
        List<Bill> payBillList = pbm.getBillList(page, this.cid);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Bill payBill : payBillList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(payBill.getId()));
            row.setAttribute("number", String.valueOf(payBill.getFormatNumber()));
            row.setAttribute("create_dt", TimeUtils.formatDate((Date)payBill.getCreateDate()));
            String user = UserMap.getUser((Integer)payBill.getUserId()).getName();
            row.setAttribute("who_created", user);
            row.setAttribute("pay_dt", TimeUtils.formatDate((Date)payBill.getPayDate()));
            row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)payBill.getSum()));
            row.setAttribute("sum", payBill.getSum().toPlainString());
            row.setAttribute("status", payBill.getStatus() == 0 ? "\u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d" : "\u043e\u043f\u043b\u0430\u0447\u0435\u043d");
            row.setAttribute("unload_status", payBill.getUnloadStatus() == 0 ? "\u043d\u0435 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d" : "\u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d");
            row.setAttribute("type", String.valueOf(payBill.getTypeId()));
            row.setAttribute("type_title", Utils.maskNull((String)payBill.getTypeTitle()));
            row.setAttribute("month", payBill.getYear() + "." + format.format(payBill.getMonth() + 1));
            user = payBill.getPayUid() > 0 ? UserMap.getUser((Integer)payBill.getPayUid()).getName() : "";
            row.setAttribute("who_payed", user);
        }
        this.setPageAttribute(table, page);
        Element pay = this.createElement(this.rootNode, "pay");
        pay.setAttribute("pay", this.moduleSetup.get("pay", "0"));
    }
}

