/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.api;

import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.ModuleSetup;

public class MegafonApiMethod
extends BGLogger {
    public static String getPath(Method method, JSONObject pathParameters) {
        StringBuilder path = new StringBuilder(method.endpoint);
        for (String key : pathParameters.keySet()) {
            String value = pathParameters.optString(key);
            int startIndex = path.indexOf("{" + key + "}");
            if (startIndex == -1) continue;
            int endIndex = startIndex + key.length() + 2;
            path.replace(startIndex, endIndex, value);
        }
        return path.toString();
    }

    public static String getPath(Method method, ModuleSetup setup, String ... configKeys) {
        StringBuilder path = new StringBuilder(method.endpoint);
        if (configKeys != null) {
            for (String configKey : configKeys) {
                String value = setup.get(configKey);
                String withoutPrefix = configKey.replace("megafon.", "");
                int startIndex = path.indexOf("{" + withoutPrefix + "}");
                int endIndex = startIndex + withoutPrefix.length() + 2;
                path.replace(startIndex, endIndex, value);
            }
        }
        return path.toString();
    }

    public static enum Method {
        GET_TOKEN("/auth/realms/{realm}/protocol/openid-connect/token", "\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u043e\u043a\u0435\u043d\u0430"),
        GET_TARIFF("/subscribers/msisdn:{msisdn}/products", "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0435\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043f\u043e \u0442\u0430\u0440\u0438\u0444\u0443"),
        GET_AVAILABLE_PRODUCTS("/subscribers/msisdn:{msisdn}/productOfferings/availableForActivate", "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0443\u0441\u043b\u0443\u0433, \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f"),
        CHECK_ACTIVATE("/subscribers/msisdn:{msisdn}/productOfferings/activate/check/bulk", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430"),
        PRODUCT_ACTIVATE("/subscribers/msisdn:{msisdn}/productOfferings/activate/bulk", "\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430"),
        PRODUCT_DEACTIVATE("/subscribers/msisdn:{msisdn}/products/deactivate/bulk", "\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430"),
        GET_NEXT_PRODUCT_CHARGES("/subscribers/msisdn:{msisdn}/subscriptions/nextCharges", "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u0442 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430"),
        ACTIVATE_SIM("/activatecomplect/set", "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0441\u0438\u043c \u043a\u0430\u0440\u0442\u044b \u0431\u0435\u0437 \u0443\u0447\u0430\u0441\u0442\u0438\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430"),
        GET_ORDER_ID("/orders/{orderId}", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 \u043f\u043e \u0435\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0443"),
        GET_CUSTOMERS_INFO("/customers/msisdn:{msisdn}", "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043f\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0443"),
        GET_INQUIRIES("/inquiries/{inquiryId}", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f CRM \u043f\u043e \u0435\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0443");

        private final String endpoint;
        private final String description;

        private Method(String endpoint, String description) {
            this.endpoint = endpoint;
            this.description = description;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

