package ru.bitel.bgbilling.modules.bill.dyn.export;

import java.sql.Connection;

import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.export.BillDocumentExport;
import ru.bitel.bgbilling.modules.bill.common.export.BillExportSaveFile;
import ru.bitel.bgbilling.modules.bill.server.bean.export.ExportInvoiceUtils;

public class InvoiceCsvExport
	implements BillDocumentExport
{
    @Override
    public String getTitle()
    {
        return "CSV";
    }
    
    @Override
    public BillExportSaveFile getSaveFile()
    {
        return new BillExportSaveFile().setFileExt( "csv" ).setFilterName( "*.csv" );
    }
	
	@Override
    public String getExportDocumentType()
    {
        return "invoice";
    }

	@Override
	public String doExport( Connection con, int moduleId, BillListFilter billListFilter, boolean saveOnServer )
		throws Exception
	{
		return new ExportInvoiceUtils( con, moduleId ).doExport( billListFilter, saveOnServer );
	}
}
