/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.bgsecure.client.MenuPanel;
import ru.bitel.bgbilling.kernel.bgsecure.client.RolePanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.common.event.PermissionKitUpdateEvent;
import ru.bitel.bgbilling.kernel.module.common.event.RoleUpdateEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class RoleEditor
extends JPanel
implements EventSubscriber<PermissionKitUpdateEvent> {
    private RolePanel parentPanel;
    private JTextField title = new JTextField();
    private BGControlPanelListSelect listIncludedRoles = new BGControlPanelListSelect();
    private BGControlPanelListSelect listPermissionKit = new BGControlPanelListSelect();
    private MenuPanel userMenuPanel;
    private List<RoleItem> roleItems;
    private List<IdTitle> permissionKits;
    private Role currentRole = null;
    private JTabbedPane tabbedPanel = new JTabbedPane();

    protected RoleEditor(RolePanel rolePanel) {
        this.parentPanel = rolePanel;
        this.userMenuPanel = new MenuPanel((ClientContext)this.parentPanel.getContext());
        this.init();
        EventBus.subscribe(PermissionKitUpdateEvent.class, (EventSubscriber)this);
    }

    public void onEvent(PermissionKitUpdateEvent event) {
        this.reloadAllRoles();
        this.reloadPermissionKit();
        this.openEditor(this.currentRole);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder(this, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u043e\u043b\u0438");
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.getButtonOk().addActionListener(e -> this.save());
        okCancel.getButton("cancel").addActionListener(e -> {
            this.setVisible(false);
            this.parentPanel.roleTreeTablePanel.getTree().setEnabled(true);
        });
        this.tabbedPanel.add((Component)this.initPermissionKitPanel(), "\u041d\u0430\u0431\u043e\u0440\u044b \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439");
        this.tabbedPanel.add((Component)this.initIncludedRolesPanel(), "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0432 \u0441\u0435\u0431\u044f \u0440\u043e\u043b\u0438");
        this.tabbedPanel.add((Component)this.userMenuPanel, "\u041c\u0435\u043d\u044e");
        this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u043e\u043b\u0438"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)this.tabbedPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 14, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.userMenuPanel.setData();
    }

    private JPanel initIncludedRolesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.reloadAllRoles();
        panel.add((Component)this.listIncludedRoles, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel initPermissionKitPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.reloadPermissionKit();
        panel.add((Component)this.listPermissionKit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void reloadPermissionKit() {
        try {
            this.permissionKits = ((ClientContext)this.parentPanel.getContext()).getPort(RoleService.class).getKitItems();
            this.listPermissionKit.getList().setData(this.permissionKits.stream().map(a -> new BGUListItem((IdTitle)a)).toList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void reloadAllRoles() {
        try {
            this.roleItems = this.parentPanel.roleService.getRoleItems(true, false);
            this.listIncludedRoles.getList().setData(this.roleItems.stream().map(a -> new BGUListItem((IdTitle)a)).toList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    protected void openEditor(Role role) {
        this.setVisible(true);
        this.parentPanel.roleTreeTablePanel.getTree().setEnabled(false);
        this.reloadAllRoles();
        this.currentRole = role;
        if (this.currentRole == null) {
            this.currentRole = new Role();
        }
        if (role == null) {
            this.title.setText("");
            this.listIncludedRoles.setListValues("");
            this.listPermissionKit.setListValues("");
            this.userMenuPanel.setSelected(0);
        } else {
            this.roleItems.removeIf(r -> r.getId() == role.getId());
            this.title.setText(role.getTitle());
            this.listIncludedRoles.getList().setData(this.roleItems.stream().map(a -> new BGUListItem((IdTitle)a)).toList());
            this.listIncludedRoles.setListValues(Utils.toString(role.getChildren().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList())));
            this.listPermissionKit.setListValues(Utils.toString(role.getPermissionKits().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList())));
            this.userMenuPanel.setSelected(role.getMenuId());
        }
        this.tabbedPanel.setSelectedIndex(0);
    }

    protected void save() {
        if (Utils.isBlankString(this.title.getText())) {
            ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u043e\u043b\u0438!");
            return;
        }
        List<Integer> selectedPermissionKit = Utils.toIntegerList(this.listPermissionKit.getListValues());
        if (Utils.isEmptyCollection(selectedPermissionKit)) {
            ClientUtils.showErrorMessageDialog("\u0420\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u043d\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c \u043e\u0434\u0438\u043d \u043d\u0430\u0431\u043e\u0440 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439");
            return;
        }
        this.currentRole.setTitle(this.title.getText());
        List<Integer> selectedIncludedRoles = Utils.toIntegerList(this.listIncludedRoles.getListValues());
        List<RoleItem> selectedRoles = this.roleItems.stream().filter(role -> selectedIncludedRoles.contains(role.getId())).collect(Collectors.toList());
        RoleItem currentRoleItem = new RoleItem(this.currentRole.getId(), this.currentRole.getTitle());
        if (this.currentRole.getId() > 0 && (!this.checkIncluded(selectedRoles) || this.checkAlreadyIncluded(currentRoleItem, selectedRoles))) {
            return;
        }
        List<Role> childRoles = selectedRoles.stream().map(ri -> new Role().setId(ri.getId()).setTitle(ri.getTitle())).collect(Collectors.toList());
        this.currentRole.setChildren(childRoles);
        this.currentRole.setMenuId(this.userMenuPanel.getSelectedId());
        this.currentRole.setPermissionKits(this.permissionKits.stream().filter(kit -> selectedPermissionKit.contains(kit.getId())).map(k -> new PermissionKit(k.getId(), k.getTitle())).toList());
        try {
            this.parentPanel.roleService.updateRole(this.currentRole);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.setVisible(false);
        this.parentPanel.roleTreeTablePanel.getTree().setEnabled(true);
        this.parentPanel.performAction("refresh");
        EventBus.publish((Object)new RoleUpdateEvent(this.currentRole.getId(), 0));
    }

    private boolean checkIncluded(List<RoleItem> included) {
        for (RoleItem includedRole : included) {
            List<RoleItem> childRoles = includedRole.getChildren();
            if (Utils.isEmptyCollection(childRoles)) continue;
            List ids = childRoles.stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
            if (ids.contains(this.currentRole.getId())) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435\u043b\u044c\u0437\u044f \u0432 \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0440\u043e\u043b\u044c \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u043e\u043b\u044c \"" + includedRole.getTitle() + "\", \u0442.\u043a. \u0442\u0435\u043a\u0443\u0449\u0430\u044f \u0440\u043e\u043b\u044c \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u0439 \u0434\u043b\u044f \u043d\u0435\u0451");
                return false;
            }
            return this.checkIncluded(childRoles);
        }
        return true;
    }

    private boolean checkAlreadyIncluded(RoleItem role, List<RoleItem> selectedRoles) {
        List childsOfRole = role.getChildren().stream().map(a -> new RoleItem(a.getId(), a.getTitle())).collect(Collectors.toList());
        if (Utils.isEmptyCollection(childsOfRole)) {
            return false;
        }
        for (RoleItem childRole : childsOfRole) {
            List<RoleItem> innerOfChildRoles = childRole.getChildren();
            for (RoleItem innerOfChildRole : innerOfChildRoles) {
                for (RoleItem selectedRole : selectedRoles) {
                    if (innerOfChildRole.getId() != selectedRole.getId()) continue;
                    ClientUtils.showErrorMessageDialog("\u0420\u043e\u043b\u044c \"" + selectedRole.getTitle() + "\" \u0443\u0436\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u0440\u043e\u043b\u0438 \"" + childRole.getTitle() + "\"");
                    return true;
                }
            }
            boolean checkResult = this.checkAlreadyIncluded(childRole, selectedRoles);
            if (!checkResult) continue;
            return true;
        }
        return false;
    }
}

