/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.service;

import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.modules.reports.common.bean.ReportAccessRule;
import ru.bitel.bgbilling.modules.reports.common.dto.ReportModule;
import ru.bitel.bgbilling.modules.reports.common.service.ReportService;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportUtils;
import ru.bitel.bgbilling.modules.reports.server.bean.ReportAccessRuleDao;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.reports.common.service.ReportService")
public class ReportServiceImpl
extends AbstractService
implements ReportService {
    private final FileFilter fileFilter = new FileFilter(this){

        @Override
        public boolean accept(File reportPath) {
            return reportPath.isFile() && reportPath.getPath().endsWith(".rep.xml");
        }
    };

    public void saveReport(String reportFileName, String xmlData) throws BGException, BGMessageException {
        File serverReportFolder = new File("reports/");
        if (serverReportFolder.exists() && serverReportFolder.isDirectory()) {
            if (this.checkReportExists(reportFileName)) {
                File reportFile = this.getReportByReportFileName(reportFileName);
                reportFile.renameTo(new File(reportFile.getName() + ".orig"));
                this.saveReport0(reportFileName, xmlData);
            } else {
                this.saveReport0(reportFileName, xmlData);
            }
        }
    }

    private void saveReport0(String reportFileName, String xmlData) throws BGException {
        try (FileWriter fileWriter = new FileWriter(new File("reports/" + reportFileName));){
            fileWriter.write(xmlData);
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean checkReportExists(String reportFileName) throws BGException, BGMessageException {
        if (((String)reportFileName).endsWith(":rep:xml")) {
            reportFileName = ((String)reportFileName).replace(":rep:xml", ".rep.xml");
        } else if (!((String)reportFileName).endsWith(".rep.xml")) {
            reportFileName = (String)reportFileName + ".rep.xml";
        }
        return this.getReportByReportFileName((String)reportFileName) != null;
    }

    private File getReportByReportFileName(String reportFileName) {
        File serverReportFolder = new File("reports/");
        if (serverReportFolder.exists() && serverReportFolder.isDirectory()) {
            for (File reportFile : serverReportFolder.listFiles(this.fileFilter)) {
                if (!reportFile.getName().equals(reportFileName)) continue;
                return reportFile;
            }
        }
        return null;
    }

    public ReportAccessRule getAccessRulesByReportId(String reportId) throws Exception {
        return new ReportAccessRuleDao(this.getConnection(), this.context.getModuleId()).getAccessRulesByReportId(reportId);
    }

    public void updateAccessRulesByReport(ReportAccessRule reportAccessRule) throws Exception {
        new ReportAccessRuleDao(this.getConnection(), this.context.getModuleId()).updateAccessRule(reportAccessRule);
    }

    public boolean checkAccessAllowByReport(String reportId) throws Exception {
        if (PermissionOfRoles.isAdmin((int)this.userId)) {
            return true;
        }
        ReportAccessRule reportAccessRule = this.getAccessRulesByReportId(reportId);
        Set allowedUsersIds = reportAccessRule.getAllowedUserIds();
        Set allowedRolesIds = reportAccessRule.getAllowedRoleIds();
        if (Utils.isEmptyCollection((Collection)allowedUsersIds) && Utils.isEmptyCollection((Collection)allowedRolesIds)) {
            return true;
        }
        if (allowedUsersIds.contains(this.userId)) {
            return true;
        }
        Optional roleOprional = PermissionOfRoles.getRoleByUserId((int)this.userId);
        if (roleOprional.isEmpty()) {
            return false;
        }
        return allowedRolesIds.contains(((Role)roleOprional.get()).getId());
    }

    public List<ReportModule> reportModules() throws Exception {
        ArrayList<ReportModule> reportModules = new ArrayList<ReportModule>();
        try {
            JSONArray array = BGReportUtils.getModuleAndPlugin(this.getModuleSetup(), this.getConnection());
            array.forEach(a -> {
                JSONObject json = (JSONObject)a;
                ReportModule reportModule = new ReportModule().setType(json.getString("type")).setTitle(json.getString("title")).setModule(json.optString("module")).setModuleId(json.optInt("moduleId"));
                reportModules.add(reportModule);
            });
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return reportModules;
    }

    public List<KeyValue> getModuleReportList(String reportModule) throws Exception {
        ArrayList<KeyValue> reports = new ArrayList<KeyValue>();
        for (BGReportUtils.Report report : BGReportUtils.getReports(reportModule, this.getConnection())) {
            if (!this.checkAccessAllowByReport(report.id)) continue;
            reports.add(new KeyValue(report.id, report.title));
        }
        return reports;
    }

    public String getReportData(String reportModule, String reportId) throws Exception {
        try {
            Document document = XMLUtils.newDocument();
            for (BGReportUtils.Report report : BGReportUtils.getReports(reportModule, this.getConnection())) {
                if (!report.id.equals(reportId)) continue;
                if (!this.checkAccessAllowByReport(report.id)) break;
                Element item = XMLUtils.createElement((Document)document, (String)"data");
                item.setAttribute("id", report.id);
                item.setAttribute("type", report.type);
                item.setAttribute("title", report.title);
                item.setAttribute("from", report.from);
                item.setAttribute("report_class", report.report_class);
                item.setAttribute("report_doc_url", report.report_doc_url);
                item.setAttribute("params_class", report.params_class);
                item.appendChild(document.importNode(report.reportElement, true));
                break;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLUtils.serialize((Node)document.getDocumentElement(), (OutputStream)outputStream, (String)"UTF-8");
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void resetReportCache() throws BGException, BGMessageException {
        BGReportUtils.resetReportCache();
    }
}

