/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransaction;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyParams;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebServlet(name="SoftkeyApi", urlPatterns={"/softkey_api/*"})
public class SoftkeyApi
extends CommonExecutor {
    private static final Pattern slashPattern = Pattern.compile("/");
    private int mid = -1;
    private SoftkeyParams params = null;
    private SoftkeyTransactionManager manager = null;

    public void init() throws ServletException {
        this.setup = Setup.getSetup();
        System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] values;
        this.getLogger().info("Connected with Softkey...");
        ServletOutputStream out = null;
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && (values = slashPattern.split(pathInfo)).length == 2) {
            this.mid = Utils.parseInt((String)values[1], (int)0);
        }
        this.params = new SoftkeyParams(this.setup.getModuleSetup(Integer.valueOf(this.mid)));
        this.manager = new SoftkeyTransactionManager(con, this.mid);
        out = resp.getOutputStream();
        con = this.setup.getDBConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(con);){
            this.getLogger().info("Getting request params...");
            String paramsFromSoftkey = req.getParameter("params");
            this.getLogger().info("Incoming params: " + paramsFromSoftkey);
            if (!Utils.isBlankString((String)paramsFromSoftkey)) {
                Document doc = XMLUtils.newDocument();
                Element resultElement = doc.createElement("result");
                Element parentElement = XMLUtils.createElement((Element)resultElement, (String)"elements");
                List<Map<String, String>> paramDetailsList = this.parseParams(paramsFromSoftkey);
                for (Map<String, String> current : paramDetailsList) {
                    String subscriberId = current.get("SUBSCRIBER_ID");
                    String orderId = current.get("ORDER_ID");
                    String amount = current.get("AMOUNT");
                    String currency = current.get("CURRENCY");
                    String srcString = subscriberId + orderId + amount + currency + "_" + this.params.getPassword();
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    digest.update(srcString.getBytes());
                    String ourHash = Utils.bytesToHexString((byte[])digest.digest()).toLowerCase();
                    if (current.get("HASH").equals(ourHash)) {
                        HashMap<String, String> dataParams = new HashMap<String, String>();
                        SoftkeyTransaction transaction = this.manager.getTransactionByCid(Integer.valueOf(subscriberId), -1);
                        if (transaction != null) {
                            Calendar nowDate = Calendar.getInstance();
                            Calendar transactionDate = Calendar.getInstance();
                            transactionDate.setTime(transaction.getPayDt());
                            if (transactionDate.get(5) == nowDate.get(5)) continue;
                            Contract c = ContractDao.getContract((Connection)con, (int)transaction.getContractId());
                            BigDecimal contractBalance = bu.getBalance(LocalDate.now(), c.getId());
                            BigDecimal transactionAmount = new BigDecimal(amount);
                            BigDecimal contractLimit = c.getBalanceLimit();
                            if (contractBalance.compareTo(contractLimit) > 0 && contractBalance.subtract(contractLimit).compareTo(transactionAmount) >= 0) {
                                dataParams.put("error_code", String.valueOf(0));
                                dataParams.put("error_message", "Success");
                                Charge charge = new Charge().setDate(new Date(System.currentTimeMillis())).setContractId(transaction.getContractId()).setSum(transactionAmount).setComment("\u041f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438").setUserId(-1).setTypeId(this.params.getChargeTypeId());
                                new ChargeDao(con).update((Object)charge);
                                ServerUtils.commitConnection((Connection)con);
                                bu.updateBalance(new Date(), transaction.getContractId());
                                transaction.setStatus(1);
                                transaction.setPayDt(new Date());
                                this.manager.updateTransaction(transaction);
                            } else {
                                this.getLogger().info("Contract balance not enought to continue subscribe (cid=" + transaction.getContractId() + ")");
                                transaction.setStatus(2);
                                dataParams.put("error_code", String.valueOf(1));
                                dataParams.put("error_message", "Not Enough Money");
                                this.manager.updateTransaction(transaction);
                            }
                            dataParams.put("subscriberId", subscriberId);
                            dataParams.put("order_id", orderId);
                            dataParams.put("amount", amount);
                            dataParams.put("currency", currency);
                            this.fillXmlAnswer(parentElement, dataParams);
                            bu.close();
                            continue;
                        }
                        this.getLogger().info("Transaction with status=ACTIVE|PAUSE|CREATE not found! ( cid=" + subscriberId + ")");
                        continue;
                    }
                    this.getLogger().info("Hashes are not equal!!! (Cid=" + subscriberId + ")");
                }
                doc.appendChild(resultElement);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLUtils.serialize((Node)doc, (OutputStream)baos, (String)"UTF-8");
                byte[] xmlData = baos.toByteArray();
                this.getLogger().info("Outgoing xml: " + new String(xmlData, "UTF-8"));
                out.write(xmlData);
                out.flush();
                out.close();
            }
        }
        catch (Exception ex) {
            this.getLogger().error("error softkey api", (Throwable)ex);
        }
    }

    private List<Map<String, String>> parseParams(String params) {
        this.getLogger().info("Parse params... ");
        ArrayList<String> paramsList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(i:\\d{2,}|[\"'][\\w\\.]+['\"])+");
        Matcher matcher = pattern.matcher(params);
        while (matcher.find()) {
            String value = matcher.group();
            if (value.startsWith("i:")) {
                paramsList.add(value.replace("i:", ""));
                continue;
            }
            paramsList.add(value.replaceAll("\"", ""));
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, String> detailMap = new HashMap<String, String>();
        for (int i = 0; i <= paramsList.size(); i += 2) {
            if (i > 0 && i % 10 == 0) {
                result.add(detailMap);
                detailMap = new HashMap();
                if (i == paramsList.size()) break;
            }
            if (i == paramsList.size()) {
                result.add(detailMap);
                continue;
            }
            detailMap.put((String)paramsList.get(i), (String)paramsList.get(i + 1));
        }
        return result;
    }

    private void fillXmlAnswer(Element parentElement, Map<String, String> dataParams) {
        Element element = XMLUtils.createElement((Element)parentElement, (String)"element");
        String key = "error_code";
        if (dataParams.containsKey(key)) {
            this.createXmlNode(element, key, dataParams.get(key));
        }
        if (dataParams.containsKey(key = "error_message")) {
            this.createXmlNode(element, key, dataParams.get(key));
        }
        if (dataParams.containsKey(key = "order_id")) {
            this.createXmlNode(element, key, dataParams.get(key));
        }
        if (dataParams.containsKey(key = "subscriberId")) {
            this.createXmlNode(element, key, dataParams.get(key));
        }
        if (dataParams.containsKey(key = "currency")) {
            this.createXmlNode(element, key, dataParams.get(key));
        }
        if (dataParams.containsKey(key = "amount")) {
            this.createXmlNode(element, key, dataParams.get(key));
        }
    }

    private void createXmlNode(Element element, String name, String content) {
        Element elem = XMLUtils.createElement((Element)element, (String)name);
        elem.setTextContent(content);
    }
}

