/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;

public class AccountRangeTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    private final int accountType;
    private final BigDecimal from;
    private final BigDecimal to;

    public AccountRangeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.accountType = parameterMap.getInt("account", 0);
        this.from = parameterMap.getBigDecimal("from", BigDecimal.ZERO);
        this.to = parameterMap.getBigDecimal("to", BigDecimal.ZERO);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest req, NPayTariffContext context) {
        ModuleAccount moduleAccount = context.getModuleAccount(this.accountType);
        if (moduleAccount == null) {
            req.addError("Not found account " + this.accountType);
            return 0;
        }
        Connection con = req.getConnection();
        BigDecimal accountValue = moduleAccount.getPeriodAccount(con, req.contractId, ((NPayServiceCost)req.serviceCost).getDate1(), ((NPayServiceCost)req.serviceCost).getDate2());
        if (req.isInfoEnabled()) {
            req.addInfo("RANGE MONEY accountValue: " + String.valueOf(accountValue) + "; from: " + String.valueOf(this.from) + "; to: " + String.valueOf(this.to));
        }
        if (accountValue != null && accountValue.compareTo(this.from) >= 0 && (this.to.compareTo(BigDecimal.ZERO) == 0 || accountValue.compareTo(this.to) <= 0)) {
            if (req.isInfoEnabled()) {
                req.addInfo("range_ok");
            }
            ((NPayServiceCost)req.serviceCost).periodAmount = accountValue;
            ((NPayServiceCost)req.serviceCost).monthAmount = this.to;
            return 1;
        }
        return 0;
    }

    protected int postExecuteImpl(Long treeNodeId, NPayTariffRequest req, NPayTariffContext context, int executeResult) {
        ((NPayServiceCost)req.serviceCost).periodAmount = null;
        ((NPayServiceCost)req.serviceCost).monthAmount = null;
        return super.postExecuteImpl(treeNodeId, (AbstractTariffRequest)req, (TariffContext)context, executeResult);
    }
}

