/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptServiceCost;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public class PacketCostTariffTreeNode
extends ModuleServiceTariffTreeNode<CerbercryptTariffContext, CerbercryptServiceCost, CerbercryptTariffRequest> {
    private int packet = -1;
    private BigDecimal cost = BigDecimal.ZERO;
    private int costType = -1;
    private boolean isDefault = false;

    public PacketCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.packet = parameterMap.getInt("packet", this.packet);
        this.cost = parameterMap.getBigDecimal("cost", this.cost);
        this.costType = parameterMap.getInt("type", this.costType);
        this.isDefault = parameterMap.getBoolean("isCostDefault", false);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, CerbercryptTariffRequest tariffRequest, TariffTreeNodeHolder holder, CerbercryptTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        if (this.isDefault && tariffRequest.isAccepted()) {
            return 1;
        }
        int packet = tariffRequest.getPacket();
        if (packet == this.packet) {
            tariffRequest.setAccepted(true);
            tariffRequest.setCost(this.cost);
            tariffRequest.setCostType(this.costType);
        }
        return 1;
    }
}

