/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.event.forpost.ForpostAccountDefaultEvent;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostAccountService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostAccountService")
public class ForpostAccountServiceImpl
extends AbstractService
implements ForpostAccountService {
    public SearchResult<ForpostAccount> searchForpostAccounts(int contractId, String accountName, String[] sort, Page page) throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            SearchResult searchResult = new SearchResult(page, sort);
            forpostAccountDao.searchForpostAccounts((SearchResult<ForpostAccount>)searchResult, contractId, accountName);
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
    }

    public void doSync() throws BGException {
        this.tryCall(() -> {
            if ("test".equals(this.getModuleSetup().get("forpost.mode", ""))) {
                throw new BGMessageException("\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c, \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u0441\u044f");
            }
            try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
                forpostAccountDao.doSync(new ForpostManager(this.moduleId).getAccounts());
            }
        });
    }

    public ForpostAccount getDefaultForpostAccount(int contractId) throws BGException {
        ForpostAccountDefaultEvent event = new ForpostAccountDefaultEvent(this.moduleId, contractId, new ForpostAccount());
        return ((ForpostAccountDefaultEvent)EventProcessor.getInstance().request((QueueEvent)event)).getForpostAccount();
    }

    public int addForpostAccount(int contractId, ForpostAccount forpostAccount) throws BGException {
        return (Integer)this.tryReturn(() -> {
            if (contractId != forpostAccount.getContractId()) {
                return 0;
            }
            ForpostAccount localForpostAccount = forpostAccount;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Name", localForpostAccount.getName());
            params.put("MaxCameraCount", String.valueOf(localForpostAccount.getMaxCameraCount()));
            params.put("MaxLoginCount", String.valueOf(localForpostAccount.getMaxLoginCount()));
            params.put("IsActive", String.valueOf(localForpostAccount.getIsActive()));
            params.putAll(Utils.linesToPairsHash((String)localForpostAccount.getData()));
            try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
                ForpostAccount[] remoteForpostAccounts;
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                ResponseId responseId = forpostManager.addAccount(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                int accountId = responseId.getId();
                localForpostAccount.setId(accountId);
                for (ForpostAccount remoteForpostAccount : remoteForpostAccounts = forpostManager.getAccounts(accountId, null, null)) {
                    if (remoteForpostAccount.getId() != accountId) continue;
                    remoteForpostAccount.setId(localForpostAccount.getId());
                    remoteForpostAccount.setName(localForpostAccount.getName());
                    localForpostAccount = remoteForpostAccount;
                    break;
                }
                forpostAccountDao.update(localForpostAccount);
                forpostAccountDao.updateAccountContract(accountId, contractId);
                Integer n = accountId;
                return n;
            }
        });
    }

    public void updateForpostAccountParam(int forpostAccountId, String name, String value) throws BGException {
        this.tryCall(() -> {
            try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
                ForpostAccount forpostAccount = forpostAccountDao.getForpostAccount(forpostAccountId);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ID", String.valueOf(forpostAccount.getId()));
                params.put(name, value);
                switch (name) {
                    case "Name": {
                        forpostAccount.setName(value);
                        break;
                    }
                    case "MaxCameraCount": {
                        forpostAccount.setMaxCameraCount(Utils.parseInt((String)value));
                        break;
                    }
                    case "MaxLoginCount": {
                        forpostAccount.setMaxLoginCount(Utils.parseInt((String)value));
                        break;
                    }
                    case "IsActive": {
                        forpostAccount.setIsActive(Utils.parseInt((String)value));
                        break;
                    }
                    default: {
                        forpostAccount.put(name, (Object)value);
                    }
                }
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                ResponseId responseId = forpostManager.editAccount(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostAccountDao.update(forpostAccount);
            }
        });
    }

    public ForpostAccount getForpostAccount(int forpostAccountId) throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            ForpostAccount forpostAccount = forpostAccountDao.getForpostAccount(forpostAccountId);
            return forpostAccount;
        }
    }

    public void deleteForpostAccount(int forpostAccountId) throws BGException {
        this.tryCall(() -> {
            try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                ResponseStatus responseStatus = forpostManager.deleteAccount(forpostAccountId);
                if (responseStatus.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostAccountDao.deleteForpostAccount(forpostAccountId);
            }
        });
    }

    public void unlinkForpostAccount(int forpostAccountId) throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            forpostAccountDao.unlinkForpostAccount(forpostAccountId);
        }
    }

    public void linkForpostAccount(int forpostAccountId, int contractId) throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            forpostAccountDao.updateAccountContract(forpostAccountId, contractId);
        }
    }
}

