/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.util;

import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class MACParser {
    private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-]+");

    public static byte[] parseMacAddress(String macAddress) {
        if (Utils.isBlankString((String)macAddress)) {
            return null;
        }
        if (macAddress.charAt(1) == ':' || macAddress.charAt(2) == ':') {
            return MACParser.semicolonedMacToBytes(macAddress);
        }
        macAddress = macClearPattern.matcher(macAddress).replaceAll("");
        return MACParser.toBytes(macAddress);
    }

    public static String macAddressToString(byte[] macAddress) {
        if (macAddress == null || macAddress.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(macAddress.length * 3);
        int size = macAddress.length;
        for (int i = 0; i < size; ++i) {
            sb.append(Utils.HEX[(macAddress[i] & 0xF0) >> 4]);
            sb.append(Utils.HEX[macAddress[i] & 0xF]);
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static byte[] toBytes(String s) {
        byte[] result;
        int i;
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        if (size % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size / 2 + 1];
            int digit2 = Character.digit(s.charAt(0), 16);
            result[0] = (byte)digit2;
        }
        while (i < size) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    private static byte[] semicolonedMacToBytes(String s) {
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        int i = 0;
        int j = 0;
        byte[] result = new byte[6];
        while (i < size && j < 6) {
            if (s.charAt(i) == ':') {
                ++i;
                continue;
            }
            int digit1 = Character.digit(s.charAt(i++), 16);
            if (i >= size || s.charAt(i) == ':') {
                result[j++] = (byte)digit1;
                continue;
            }
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }
}

