/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.sequence.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.sequence.common.bean.BGSequence;
import ru.bitel.bgbilling.kernel.sequence.common.bean.enums.BGSequenceMode;
import ru.bitel.bgbilling.kernel.sequence.common.bean.enums.BGSequenceType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class BGSequenceDao
extends AbstractIdDao<BGSequence> {
    public BGSequenceDao(Connection con) {
        super(con, "counter_sequence");
    }

    public List<BGSequence> list(BGSequenceType sequenceType) throws SQLException {
        return this.list("sequence_type=?", "title", new Object[]{sequenceType.name()});
    }

    protected BGSequence getFromRS(ResultSet rs) throws SQLException {
        return new BGSequence(rs.getInt("id"), rs.getString("title")).setCounter(rs.getLong("counter")).setResetDate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("reset_date"))).setSequenceMode(BGSequenceMode.valueOf(rs.getString("sequence_mode"))).setSequenceType(BGSequenceType.valueOf(rs.getString("sequence_type")));
    }

    protected void updateImpl(BGSequence sequence) throws SQLException {
        String querySet = "title=?, reset_date=?, sequence_mode=?, sequence_type=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)sequence, querySet);){
            int index = 1;
            ps.setString(index++, sequence.getTitle());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)sequence.getResetDate()));
            ps.setString(index++, sequence.getSequenceMode().name());
            ps.setString(index++, sequence.getSequenceType().name());
            this.executeUpdate((Id)sequence, index, ps);
        }
    }
}

