/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.common.clientlocal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.sbpilot.common.bean.SbPilotPayment;
import ru.bitel.bgbilling.plugins.sbpilot.common.clientlocal.CashcheckClientWrapper;
import ru.bitel.bgbilling.plugins.sbpilot.common.clientlocal.SbPilotBinWrapper;
import ru.bitel.bgbilling.plugins.sbpilot.common.clientlocal.SberErr;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SbPilotDialog
extends JDialog
implements SbPilotBinWrapper.WrapperAction {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTextArea logArea = new JTextArea();
    private JLabel statusLabel = new JLabel("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f\u2026");
    private JLabel operationLabel = new JLabel("?");
    private JLabel summaLabel = new JLabel("-");
    private SbPilotBinWrapper binWrapper;
    private CashcheckClientWrapper cashcheckClientWrapper;
    private JButton closeButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
    private int successCloseButtonTime = -1;
    private JButton abortButton = new JButton("\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c");
    private int abortButtonTime = 60;
    private Preferences setup = null;
    private SbPilotBinWrapper.E efile = null;

    public SbPilotDialog(Preferences setup) {
        File pb;
        this.setup = setup;
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(false);
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(e -> this.dispose());
        this.abortButton.setEnabled(false);
        this.abortButtonTime = setup.getInt("sbpilot.abort.timeout", this.abortButtonTime);
        Timer abortButtonTimer = new Timer(1000, e -> {
            --this.abortButtonTime;
            if (this.abortButtonTime > 0) {
                this.abortButton.setText("\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c (" + this.abortButtonTime + ")");
            } else {
                this.abortButton.setText("\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c");
                this.abortButton.setEnabled(true);
                ((Timer)e.getSource()).stop();
            }
        });
        abortButtonTimer.start();
        this.abortButton.addActionListener(e -> {
            if (SbPilotDialog.confirm("\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0440\u0430\u0431\u043e\u0442\u0443 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f? \u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u043e\u043d\u0438\u043c\u0430\u0442\u044c \u0437\u0430\u0447\u0435\u043c \u044d\u0442\u043e \u0434\u0435\u043b\u0430\u0435\u0442\u0435.", "\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c \u0443\u0442\u0438\u043b\u0438\u0442\u0443")) {
                this.binWrapper.abort();
            }
        });
        this.successCloseButtonTime = setup.getInt("sbpilot.success.close.timeout", this.successCloseButtonTime);
        this.setTitle("SBPilot");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setPreferredSize(new Dimension(600, 200));
        this.getContentPane().setMinimumSize(new Dimension(600, 200));
        this.getContentPane().add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel tab1 = new JPanel(new GridBagLayout());
        tab1.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)this.operationLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)this.summaLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)this.statusLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)this.abortButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)this.closeButton, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tabbedPane.add((Component)tab1, "\u041f\u0438\u043d\u043f\u0430\u0434");
        this.logArea.setLineWrap(true);
        this.logArea.setWrapStyleWord(true);
        this.tabbedPane.add((Component)new JScrollPane(this.logArea), "Log");
        this.pack();
        this.setLocationRelativeTo(null);
        String pathBin = setup.get("sbpilot.path.bin", null);
        String pathE = setup.get("sbpilot.path.e", null);
        String pathP = setup.get("sbpilot.path.p", null);
        String pathE2 = setup.get("sbpilot.path.e2", null);
        File file = pb = pathBin != null ? new File(pathBin) : null;
        if (pb != null && pb.isFile() && (pathE != null || pathE2 != null) && pathP != null) {
            File wd = pb.getParentFile();
            this.binWrapper = new SbPilotBinWrapper(pb, wd, pathE, pathP, pathE2, this);
        } else {
            SbPilotDialog.showErrorMessageDialog("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0438\u043d\u043f\u0430\u0434\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b");
        }
        String ccConnector = setup.get("sbpilot.cashcheckserver.connector", null);
        String ccOppass = setup.get("sbpilot.cashcheckserver.oppass", null);
        if (ccConnector != null && ccOppass != null) {
            try {
                this.cashcheckClientWrapper = new CashcheckClientWrapper(ccConnector, ccOppass);
            }
            catch (BGException ex) {
                SbPilotDialog.showErrorMessageDialog("\u041f\u0435\u0447\u0430\u0442\u044c \u0441\u043b\u0438\u043f\u043e\u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438");
                BGLogger.error((Throwable)ex);
            }
        } else {
            SbPilotDialog.showErrorMessageDialog("\u041f\u0435\u0447\u0430\u0442\u044c \u0441\u043b\u0438\u043f\u043e\u0432 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430");
        }
    }

    private boolean doAction(final Operations op, final String summa, final String authcode) {
        if (this.binWrapper == null || this.cashcheckClientWrapper == null) {
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        this.operationLabel.setText(op.getTitle());
        this.summaLabel.setText(summa != null ? summa : "-");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Object parseEresult;
                int summakop = -1;
                if (summa != null) {
                    try {
                        summakop = new BigDecimal(summa).multiply(new BigDecimal(100)).intValue();
                    }
                    catch (Exception e) {
                        SbPilotDialog.this.setStatus("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0443\u043c\u043c\u044b", false, e.toString(), true);
                        return;
                    }
                }
                try {
                    switch (op.ordinal()) {
                        case 0: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doPayment(summakop);
                            break;
                        }
                        case 1: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0441\u043d\u044f\u0442\u0438\u044f \u043a\u0440\u0430\u0442\u043a\u043e\u0433\u043e x-\u043e\u0442\u0447\u0451\u0442\u0430\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doX(false);
                            break;
                        }
                        case 2: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0441\u043d\u044f\u0442\u0438\u044f \u043f\u043e\u043b\u043d\u043e\u0433\u043e x-\u043e\u0442\u0447\u0451\u0442\u0430\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doX(true);
                            break;
                        }
                        case 3: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0441\u043d\u044f\u0442\u0438\u044f z-\u043e\u0442\u0447\u0451\u0442\u0430\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doZ();
                            break;
                        }
                        case 4: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u043e\u0442\u043c\u0435\u043d\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doCancel13(summakop, authcode);
                            break;
                        }
                        case 5: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0430 \u0447\u0435\u043a\u0430\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doRepeat();
                            break;
                        }
                        case 6: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043e\u043a\u0443\u043f\u043a\u0438\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doCancel8(summakop);
                            break;
                        }
                        case 7: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doCancel3(summakop);
                            break;
                        }
                        case 8: {
                            SbPilotDialog.this.setStatus("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0438\u043d\u0444\u043e\u2026", true, null, false);
                            SbPilotDialog.this.binWrapper.doInfo();
                        }
                    }
                }
                catch (BGException e) {
                    SbPilotDialog.this.setStatus("\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", false, e.toString(), true);
                    e.printStackTrace();
                    result.set(false);
                    return;
                }
                SbPilotDialog.this.setAlwaysOnTop(true);
                SbPilotDialog.this.toFront();
                SbPilotDialog.this.setStatus("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432\u2026", true, null, false);
                try {
                    SbPilotDialog.this.efile = SbPilotDialog.this.binWrapper.parseE();
                    if (0 == SbPilotDialog.this.efile.errcode) {
                        parseEresult = "\u0423\u0441\u043f\u0435\u0448\u043d\u043e";
                        SbPilotDialog.this.setStatus("\u0423\u0441\u043f\u0435\u0448\u043d\u043e\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435", true, null, false);
                        result.set(true);
                    } else {
                        parseEresult = "\u041e\u0448\u0438\u0431\u043a\u0430 #" + SbPilotDialog.this.efile.errcode + (String)(Utils.notBlankString((String)SbPilotDialog.this.efile.errmsg) ? " (" + SbPilotDialog.this.efile.errmsg + ")" : "");
                        Object addErrMessage = new SberErr().getMessage(SbPilotDialog.this.efile.errcode);
                        if (addErrMessage != null) {
                            addErrMessage = "\u0414\u043e\u043f. \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e \u043a\u043e\u0434\u0443 \u043e\u0448\u0438\u0431\u043a\u0438 (\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e! \u043d\u0435\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0438\u0437 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430): " + (String)addErrMessage;
                        }
                        SbPilotDialog.this.setStatus("\u0412\u0435\u0440\u043d\u0443\u043b\u0430\u0441\u044c \u043e\u0448\u0438\u0431\u043a\u0430: " + (String)parseEresult, false, (String)addErrMessage, false);
                        result.set(false);
                    }
                }
                catch (BGException e) {
                    parseEresult = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u043c\u043e\u0434\u0443\u043b\u044f";
                    SbPilotDialog.this.setStatus("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043d\u0430\u043b\u0438\u0437\u0435 \u0432\u044b\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0443\u0442\u0438\u043b\u0438\u0442\u044b", false, e.getCause() != null ? e.getCause().toString() : e.toString(), false);
                    result.set(false);
                }
                String printResult = "";
                String checkText = SbPilotDialog.this.binWrapper.getNeedPrintCheck();
                if (checkText != null) {
                    SbPilotDialog.this.setStatus("\u041f\u0435\u0447\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u2026", true, "\u041f\u0435\u0447\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0430 " + SbPilotDialog.this.cashcheckClientWrapper.getConnector() + "...", false);
                    try {
                        String schar = SbPilotDialog.this.setup.get("sbpilot.cashcheckserver.charcut", null);
                        String charcut = schar != null ? new String(Utils.stringToBytes((String)schar, (String)"")) : null;
                        SbPilotDialog.this.cashcheckClientWrapper.print(checkText, SbPilotDialog.this.setup.getBoolean("sbpilot.cashcheckserver.endcut", false), charcut);
                        printResult = " (\u0438 \u0441\u043b\u0438\u043f \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d)";
                    }
                    catch (BGException e) {
                        printResult = " (\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u043b\u0438\u043f\u0430: \u0441\u043c.\u043b\u043e\u0433)";
                        SbPilotDialog.this.setStatus("\u041f\u0435\u0447\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439", false, e.toString(), false);
                    }
                } else {
                    printResult = " (\u041f\u0435\u0447\u0430\u0442\u044c \u0441\u043b\u0438\u043f\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f)";
                    SbPilotDialog.this.setStatus("\u041f\u0435\u0447\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f", true, null, false);
                }
                SbPilotDialog.this.setStatus("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e: " + (String)parseEresult + printResult, result.get(), null, true);
                SbPilotDialog.this.toFront();
            }
        }, "SbPilotDialog action thread").start();
        this.setVisible(true);
        return result.get();
    }

    public SbPilotPayment doPayment(String summa) {
        boolean result = this.doAction(Operations.PAYMENT, summa, null);
        return result ? this.makeSbPilotPaymentBean() : null;
    }

    public boolean doX0() {
        return this.doAction(Operations.X_0, null, null);
    }

    public boolean doX1() {
        return this.doAction(Operations.X_1, null, null);
    }

    public boolean doZ() {
        return this.doAction(Operations.Z, null, null);
    }

    public boolean doCancel13(String summa, String authcode) {
        return this.doAction(Operations.CANCEL13, summa, authcode);
    }

    public boolean doRepeat() {
        return this.doAction(Operations.REPEAT, null, null);
    }

    public boolean doCancel8(String summa) {
        return this.doAction(Operations.CANCEL8, summa, null);
    }

    public boolean doCancel3(String summa) {
        return this.doAction(Operations.CANCEL3, summa, null);
    }

    public boolean doInfo() {
        return this.doAction(Operations.INFO, null, null);
    }

    public void setStatus(final String status, final boolean successStatus, final String log, final boolean setexit) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (status != null) {
                    SbPilotDialog.this.statusLabel.setText(status);
                    SbPilotDialog.this.statusLabel.setForeground(successStatus ? UIManager.getColor("Label.foreground") : Color.RED);
                    System.out.println("sbpilot:status:" + status);
                    SbPilotDialog.this.logArea.append((successStatus ? "[INFO] " : "[ERROR] ") + status + "\n\n");
                } else {
                    SbPilotDialog.this.statusLabel.setText("\u0420\u0430\u0431\u043e\u0442\u0430 \u043c\u043e\u0434\u0443\u043b\u044f\u2026");
                    SbPilotDialog.this.statusLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
                if (log != null) {
                    SbPilotDialog.this.logArea.append(log + "\n\n");
                    System.out.println("sbpilot:log:" + log);
                }
                if (setexit) {
                    SbPilotDialog.this.closeButton.setEnabled(true);
                    SbPilotDialog.this.abortButton.setVisible(false);
                    if (successStatus && SbPilotDialog.this.successCloseButtonTime > 0) {
                        Timer closeButtonTimer = new Timer(1000, ev -> {
                            --SbPilotDialog.this.successCloseButtonTime;
                            if (SbPilotDialog.this.successCloseButtonTime > 0) {
                                SbPilotDialog.this.closeButton.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c (" + SbPilotDialog.this.successCloseButtonTime + ")");
                            } else {
                                ((Timer)ev.getSource()).stop();
                                SbPilotDialog.this.closeButton.doClick();
                            }
                        });
                        closeButtonTimer.start();
                    }
                }
            }
        });
    }

    @Override
    public void line(String line) {
        this.setStatus(null, true, "wrapper:" + line, false);
    }

    private SbPilotPayment makeSbPilotPaymentBean() {
        SbPilotPayment payment = new SbPilotPayment();
        payment.setCardnum(this.efile.cardnum);
        payment.setCarddate(this.efile.carddate);
        payment.setAuthcode(this.efile.authcode);
        payment.setInternalnum(this.efile.internalnum);
        payment.setCardtype(this.efile.cardtype);
        return payment;
    }

    public static boolean confirm(String message, String title) {
        return 0 == JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, title, 0);
    }

    public static void showErrorMessageDialog(String message) {
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
    }

    private static enum Operations {
        PAYMENT("\u041e\u043f\u043b\u0430\u0442\u0430"),
        X_0("X-\u043e\u0442\u0447\u0451\u0442 \u043a\u0440\u0430\u0442\u043a\u0438\u0439"),
        X_1("X-\u043e\u0442\u0447\u0451\u0442 \u043f\u043e\u043b\u043d\u044b\u0439"),
        Z("Z-\u043e\u0442\u0447\u0451\u0442"),
        CANCEL13("\u041e\u0442\u043c\u0435\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"),
        REPEAT("\u041f\u043e\u0432\u0442\u043e\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0447\u0435\u043a\u0430"),
        CANCEL8("\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043e\u043a\u0443\u043f\u043a\u0438"),
        CANCEL3("\u0412\u043e\u0437\u0432\u0440\u0430\u0442"),
        INFO("\u0418\u043d\u0444\u043e");

        private String title;

        private Operations(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

