/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.jasperreports.engine.JasperReport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocSendLog;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentSendMode;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocSendLogDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.EmailMaster;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.mail.MailViewDocs;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionViewDocs
extends ActionBase {
    public void doAction() throws Exception {
        byte[] data;
        int id = this.getIntParameter("codes", -1);
        String type = this.getParameter("type");
        if (this.mid <= 0 || id <= 0 || Utils.isBlankString((String)type)) {
            throw new BGIllegalArgumentException();
        }
        Document dataDoc = XMLUtils.newDocument();
        Element dataNode = XMLUtils.createElement((Document)dataDoc, (String)"data");
        BillUtil.addInline(dataNode, (Preferences)this.moduleSetup, this.userId);
        byte[] byArray = data = type.equals("bill") ? new BillManager(this.con, this.mid).getXMLData(id) : new InvoiceManager(this.con, this.mid).getXMLData(id);
        if (data != null) {
            Document billDoc;
            try {
                billDoc = XMLUtils.parseDocument((byte[])data, (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 xml \u0438\u0437 \u0411\u0414 (type=" + type + ", id=" + id + "): " + e.getCause().toString(), (Throwable)e);
            }
            try {
                Element bill = XMLUtils.selectElement((Node)billDoc, (String)"//bill");
                dataNode.appendChild(dataDoc.importNode(bill, true));
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 xml \u0438\u0437 \u0411\u0414 (type=" + type + ", id=" + id + ")", (Throwable)e);
            }
        }
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("mid", String.valueOf(this.mid));
        String contentType = this.getParameter("contentType");
        String maildest = this.getParameter("maildest");
        if (Utils.notBlankString((String)maildest)) {
            BillDoc billDoc = "bill".equals(type) ? (BillDoc)Optional.ofNullable(new BillManager(this.con, this.mid).getBill(id)).orElse(null) : (BillDoc)Optional.ofNullable(new InvoiceManager(this.con, this.mid).getInvoice(id)).orElse(null);
            int contractId = Optional.ofNullable(billDoc).map(a -> a.getContractId()).orElse(0);
            BigDecimal documentSum = Optional.ofNullable(billDoc).map(a -> a.getSum()).orElse(BigDecimal.ZERO);
            BillDocSendLog billDocSendLog = new BillDocSendLog().setContractId(contractId).setDocumentType("bill".equals(type) ? DocumentType.BILL : DocumentType.INVOICE).setDocumentId(id).setDocumentSum(documentSum).setSendTime(LocalDateTime.now()).setSendMode(DocumentSendMode.EMAIL).setSendAddress(maildest).setSendUserId(this.userId.intValue());
            try {
                EmailMaster master = new EmailMaster(this.setup, this.con, this.mid, this.userId);
                master.setDocumentId("bill".equals(type) ? DocumentSendParameters.SendingDataType.BILL : DocumentSendParameters.SendingDataType.INVOICE, id);
                master.setContractId(-1);
                MailData mailData = new MailViewDocs().setModuleId(this.mid).setRecipients(maildest).setSubject(master.getSubject());
                master.addMessage(mailData, "text");
                master.addAttach(mailData, "file1");
                new MailMsg((Preferences)this.setup).sendMessage(mailData);
                billDocSendLog.setSendStatus("OK");
            }
            catch (Exception ex) {
                billDocSendLog.setSendStatus("ERROR").setSendStatusMessage(ex.getLocalizedMessage());
                throw new BGException((Throwable)ex);
            }
            new BillDocSendLogDao(this.con, this.mid).update(billDocSendLog);
        } else {
            String patternName = BillUtil.getPatternName("bill".equals(type) ? DocumentSendParameters.SendingDataType.BILL : DocumentSendParameters.SendingDataType.INVOICE, this.con, this.mid, id);
            try {
                if ("application/pdf".equals(contentType)) {
                    this.request.setAttribute("contentType", (Object)"binary");
                    this.response.setContentType("application/pdf");
                    BillUtil.convertDocument(this.setup, this.con, this.mid, dataDoc, patternName, (OutputStream)this.response.getOutputStream());
                } else if (patternName.endsWith(".jrxml")) {
                    this.request.setAttribute("contentType", (Object)"binary");
                    JasperReport report = BGReportTemplate.getJasperReport((URI)new File(XSLManager.getInstance().getXslRootPath() + patternName).toURI());
                    BGReportTemplate.fillReportToStream((JasperReport)report, (BGReportFilter)new BGReportFilter(filter, (Preferences)this.setup, this.userId.intValue()), (Connection)this.con, (Document)dataDoc, (OutputStream)this.response.getOutputStream());
                } else {
                    this.response.setContentType("text/xml");
                    this.docToFO(dataDoc, this.rootNode, patternName);
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected void docToFO(Document doc, Element rootNode, String patternName) throws BGException {
        XSLManager.getInstance().transform((Source)new DOMSource(doc), patternName, (Node)rootNode);
    }
}

