/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.moneta.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.modules.moneta.common.bean.Transaction;
import ru.bitel.bgbilling.modules.moneta.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "moneta_transaction", moduleId);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws SQLException {
        int index;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder queryFromWhere = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true").append(this.queryPeriod(period, "pt.create_date"));
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            queryFromWhere.append(" AND pt.status=?");
        }
        if (Utils.notBlankString((String)contractTitle)) {
            queryFromWhere.append(" AND c.title LIKE ?");
        }
        if (contractId > 0) {
            queryFromWhere.append(" AND c.id=").append(contractId);
        }
        String query = "SELECT pt.*, c.title AS contract_title" + queryFromWhere.toString() + this.getSQLOrder(sort, this.fields) + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                ps.setString(index++, status);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs, true));
                }
            }
        }
        ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + queryFromWhere.toString());
        try {
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                ps.setString(index++, status);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            this.executeQuerySumPage(ps, searchResult);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    protected Transaction getFromRS(ResultSet rs, boolean initContractTitle) throws SQLException {
        return new Transaction().setId(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setContractTitle(initContractTitle ? rs.getString("contract_title") : null).setPaymentId(rs.getInt("payment_id")).setCreateDate((Date)rs.getTimestamp("create_date")).setTransactionDate((Date)rs.getTimestamp("transaction_date")).setTransactionId(rs.getString("transaction_id")).setStatus(rs.getString("status")).setParameters(rs.getString("params")).setSum(rs.getBigDecimal("sum"));
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, status=?, params=?, sum=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public Transaction doSign(int contractId, BigDecimal sum, boolean autopaymentTransaction, String signCheckCode, Map<String, Object> dataMap) throws Exception {
        Transaction transaction = new Transaction().setSum(sum).setContractId(contractId).setCreateDate(new Date()).setAutopayment(autopaymentTransaction).setTransactionId("").setParameters("");
        this.update(transaction);
        String signData = dataMap.get("MNT_ID") + transaction.getId() + dataMap.get("MNT_AMOUNT") + dataMap.get("MNT_CURRENCY_CODE") + String.valueOf(contractId) + dataMap.get("MNT_TEST_MODE") + signCheckCode;
        String sign = Utils.getDigest((String)signData, (String)"UTF-8");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SIGNATURE DATA: " + signData);
            this.getLogger().debug("SIGNATURE: " + sign);
        }
        dataMap.put("MNT_TRANSACTION_ID", String.valueOf(transaction.getId()));
        dataMap.put("MNT_SIGNATURE", sign);
        return transaction;
    }
}

