/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.plugins.edo.client.SearchContragentDialog;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.EdoDocumentType;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.common.bean.Signatory;
import ru.bitel.bgbilling.plugins.edo.common.service.EdoDocumentTypeService;
import ru.bitel.bgbilling.plugins.edo.common.service.SignatoryService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.GuiTitlable;

public class SendEdoManualDialog
extends JDialog
implements ActionListener {
    private final SendEdoManualDialogContext owner;
    private BGUComboBox<EdoDocumentType> edoEdoDocumentTypeCB = new BGUComboBox();
    private BGUComboBox<Signatory> edoSignatoryCB = new BGUComboBox();
    private BGButton searchButton = new BGButton(null, (Icon)ClientUtils.getIcon((String)"loopa_fade"), "search", (ActionListener)this);
    private BGButton saveButton = new BGButton("\u0412 \u0444\u0430\u0439\u043b", "save", (ActionListener)this);
    private BGButton sendButton = new BGButton("\u0412 \u042d\u0414\u041e", "send", (ActionListener)this);
    private BGButton cancelButton = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0430", "cancel", (ActionListener)this);
    private JLabel contragentInfoLabel = new JLabel("-");
    private ContragentInfos contragentInfos;
    private ClientContext clientContext;

    public SendEdoManualDialog(ClientContext clientContext, SendEdoManualDialogContext owner) {
        this.clientContext = clientContext;
        this.owner = owner;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(1);
        this.setModal(true);
        this.setTitle("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0432 \u042d\u0414\u041e");
        this.add((Component)new JLabel("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.searchButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.contragentInfoLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.edoEdoDocumentTypeCB, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.edoSignatoryCB, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)this.saveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add(Box.createGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)this.sendButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)this.cancelButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)bottomPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.edoEdoDocumentTypeCB.setEnabled(false);
        this.edoSignatoryCB.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.sendButton.setEnabled(false);
        this.setSize(640, 480);
        this.setMinimumSize(new Dimension(480, 240));
        this.pack();
        this.setLocationRelativeTo((Component)BGClientBase.getFrame());
        this.refresh();
    }

    private void refresh() {
        try {
            List edoDocumentTypeList = ((EdoDocumentTypeService)this.clientContext.getPort(EdoDocumentTypeService.class)).getEdoDocumentTypeList(false);
            if (Utils.notEmptyCollection((Collection)edoDocumentTypeList)) {
                if (edoDocumentTypeList.size() > 1) {
                    this.edoEdoDocumentTypeCB.assignEmptyValue((GuiTitlable)((EdoDocumentType)new EdoDocumentType().setAsNoSelect(EdoDocumentType.class)));
                }
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0430\u0434\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0442\u0438\u043f\u044b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
                return;
            }
            this.edoEdoDocumentTypeCB.setData(edoDocumentTypeList);
            List signatoryList = ((SignatoryService)this.clientContext.getPort(SignatoryService.class)).getSignatoryList();
            if (Utils.notEmptyCollection((Collection)signatoryList)) {
                if (signatoryList.size() > 1) {
                    this.edoSignatoryCB.assignEmptyValue((GuiTitlable)((Signatory)new Signatory().setAsNoSelect(Signatory.class)));
                }
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0430\u0434\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442\u043e\u0432");
                return;
            }
            this.edoSignatoryCB.setData(signatoryList);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("save".equals(actionCommand)) {
            this.saveEdo();
        } else if ("send".equals(actionCommand)) {
            this.sendEdo();
        } else if ("search".equals(actionCommand)) {
            this.searchContragent();
        } else if ("cancel".equals(actionCommand)) {
            this.setVisible(false);
        }
    }

    private void searchContragent() {
        int contractId = this.owner.getContractId();
        if (contractId <= 0) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u043e \u0447\u0442\u043e \u0437\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c");
            return;
        }
        ContragentInfos _contragentInfos = SearchContragentDialog.doSearch(this.clientContext, contractId);
        this.setContragentInfos(_contragentInfos);
    }

    public void setContragentInfos(ContragentInfos _contragentInfos) {
        this.contragentInfos = _contragentInfos;
        if (this.contragentInfos != null) {
            this.edoEdoDocumentTypeCB.setEnabled(true);
            this.edoSignatoryCB.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.sendButton.setEnabled(true);
            this.contragentInfoLabel.setText("<html>" + this.contragentInfos.toStringFullId().replace("\n", "<br/>") + "</html>");
        } else {
            this.edoEdoDocumentTypeCB.setEnabled(false);
            this.edoSignatoryCB.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.sendButton.setEnabled(false);
            this.contragentInfoLabel.setText("-");
        }
        this.pack();
    }

    private void saveEdo() {
        block12: {
            if (this.edoEdoDocumentTypeCB.getSelectedId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                return;
            }
            if (this.edoSignatoryCB.getSelectedId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442\u0430");
                return;
            }
            if (this.contragentInfos == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0438\u0441\u043a \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430?");
                return;
            }
            try {
                FileDto fileDto = this.owner.callSaveEdo(this.edoEdoDocumentTypeCB.getSelectedId(), this.edoSignatoryCB.getSelectedId(), this.contragentInfos);
                BGFileChooser fc = new BGFileChooser((Component)this);
                File dir = fc.getCurrentDirectory();
                File selfile = new File(String.valueOf(dir.getAbsoluteFile()) + File.separator + fileDto.getFileName());
                fc.setSelectedFile(selfile);
                if (fc.showSaveDialog() != 0) break block12;
                try (FileOutputStream out = new FileOutputStream(fc.getSelectedFile());){
                    out.write(Base64.getDecoder().decode(fileDto.getData()));
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0442\u043e\u043a\u0430, \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void sendEdo() {
        if (this.edoEdoDocumentTypeCB.getSelectedId() <= 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            return;
        }
        if (this.edoSignatoryCB.getSelectedId() <= 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442\u0430");
            return;
        }
        if (this.contragentInfos == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0438\u0441\u043a \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430?");
            return;
        }
        if (!this.owner.confirmSendEdo(this.contragentInfos)) {
            return;
        }
        try {
            ExtDocument document = this.owner.callSendEdo(this.edoEdoDocumentTypeCB.getSelectedId(), this.edoSignatoryCB.getSelectedId(), this.contragentInfos);
            if (document == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0447\u0442\u043e \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e...");
                return;
            }
            this.setVisible(false);
            if (!ClientUtils.confirm((String)"\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0435?", (String)"\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442")) {
                return;
            }
            if (Utils.isBlankString((String)document.getExtLink())) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0440\u0438\u0448\u0451\u043b \u0431\u0435\u0437 \u0441\u0441\u044b\u043b\u043a\u0438");
                return;
            }
            ClientUtils.openBrowser((URI)new URI(document.getExtLink()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public static interface SendEdoManualDialogContext {
        public int getContractId();

        public FileDto callSaveEdo(int var1, int var2, ContragentInfos var3) throws Exception;

        public boolean confirmSendEdo(ContragentInfos var1);

        public ExtDocument callSendEdo(int var1, int var2, ContragentInfos var3) throws Exception;
    }
}

