/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.common.service;

import jakarta.activation.DataHandler;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.MTOM;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.ChangeManager;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.FileInfo;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.HelpDeskLinks;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.common.dto.ContractModeDTO;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService
@MTOM(enabled=true)
@XmlSeeAlso(value={BGServerFile.class, Topic.class, Message.class, IdTitle.class, KeyValue.class, Package.class})
public interface HelpdeskService {
    @WebMethod
    public int reservStatusUpdate(@WebParam(name="topicId") int var1, @WebParam(name="reserveStatus") int var2) throws BGException;

    @WebMethod
    public int reserveStatusGet(@WebParam(name="topicId") int var1) throws BGException;

    @WebMethod
    public int topicCostUpdate(@WebParam(name="topicId") int var1, @WebParam(name="sum") BigDecimal var2) throws BGException;

    @WebMethod
    public int topicNotificationUpdate(@WebParam(name="topicId") int var1, @WebParam(name="mode") int var2, @WebParam(name="value") String var3) throws BGException;

    @WebMethod
    public void fileDelete(@WebParam(name="fileId") int var1) throws BGException;

    @WebMethod
    public FileDto fileDownload(@WebParam(name="fileId") int var1, @WebParam(name="contractId") int var2) throws BGException;

    @WebMethod
    public FileInfo fileUpload(@WebParam(name="topicId") String var1, @WebParam(name="uuid") String var2, @WebParam(name="filename") String var3, @WebParam(name="size") long var4, @WebParam(name="fileData", mode=WebParam.Mode.INOUT) Holder<DataHandler> var6) throws BGException;

    @WebMethod
    public MapHolder<IdTitle, List<IdTitle>> categoryMapForContract(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public int[] topicCreate(@WebParam(name="topic") Topic var1, @WebParam(name="message") Message var2) throws BGException;

    @WebMethod
    public Topic topicGet(@WebParam(name="contractId") int var1, @WebParam(name="topicId") int var2, @WebParam(name="loadMessages") boolean var3) throws BGException;

    @WebMethod
    public SearchResult<Topic> topicSearch(@WebParam(name="topicId") int var1, @WebParam(name="title") String var2, @WebParam(name="message") String var3, @WebParam(name="status") int var4, @WebParam(name="userSelect") String var5, @WebParam(name="onlynew") boolean var6, @WebParam(name="closed") boolean var7, @WebParam(name="period") Period var8, @WebParam(name="page") Page var9) throws BGException;

    @WebMethod
    public Result<Topic> topicList(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2, @WebParam(name="history") Boolean var3, @WebParam(name="dateFrom") Date var4, @WebParam(name="dateTo") Date var5, @WebParam(name="title") String var6, @WebParam(name="message") String var7, @WebParam(name="page") Page var8) throws BGException;

    @WebMethod
    public void topicMarkReadByCustomer(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2) throws Exception;

    @WebMethod
    public void topicUpdateState(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2, @WebParam(name="state") boolean var3) throws Exception;

    @WebMethod
    public int messageUpdate(@WebParam(name="message") Message var1) throws Exception;

    @WebMethod
    public int messagePrevId(@WebParam(name="topicId") int var1, @WebParam(name="id") int var2) throws Exception;

    @WebMethod
    public int messageNextId(@WebParam(name="topicId") int var1, @WebParam(name="id") int var2) throws Exception;

    @WebMethod
    public int messageNewCount() throws BGException;

    @WebMethod
    public List<IdTitle> topicStatusList() throws BGException;

    @WebMethod
    public SearchResult<IdTitle> categoryList(@WebParam(name="page") Page var1) throws Exception;

    @WebMethod
    public void categoryUpdate(@WebParam(name="categoryId") int var1, @WebParam(name="title") String var2) throws BGException;

    @WebMethod
    public void categoryDelete(@WebParam(name="categoryId") int var1) throws BGException;

    @WebMethod
    public void categoryToGroupAdd(@WebParam(name="groupId") int var1, @WebParam(name="categoryIds") List<Integer> var2) throws BGException;

    @WebMethod
    public void categoryToGroupDelete(@WebParam(name="groupId") int var1, @WebParam(name="categoryIds") List<Integer> var2) throws BGException;

    @WebMethod
    public List<IdTitle> categoryGroupList() throws BGException;

    @WebMethod
    public HelpDeskLinks categoryGroupLinks(@WebParam(name="groupId") int var1) throws BGException;

    @WebMethod
    public SearchResult<IdTitle> subcategoryList(@WebParam(name="page") Page var1) throws Exception;

    @WebMethod
    public void subcategoryToCategoryAdd(@WebParam(name="groupId") int var1, @WebParam(name="categoriesIds") Set<Integer> var2, @WebParam(name="subCategoriesIds") Set<Integer> var3) throws BGException;

    @WebMethod
    public void subcategoryToCategoryDelete(@WebParam(name="groupId") int var1, @WebParam(name="categoriesIds") Set<Integer> var2, @WebParam(name="subCategoriesIds") Set<Integer> var3) throws BGException;

    @WebMethod
    public List<String> categorySubcategoryIdsForGroup(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public List<IdTitle> managerList() throws BGException;

    @WebMethod
    public List<ChangeManager> topicManagerChangeList(@WebParam(name="topicId") int var1) throws BGException;

    @WebMethod
    public void topicManagerChange(@WebParam(name="topicId") int var1, @WebParam(name="managerId") int var2, @WebParam(name="comment") String var3) throws BGException;

    @WebMethod
    public void topicStatusUpdate(@WebParam(name="topicId") int var1, @WebParam(name="status") int var2) throws BGException;

    @WebMethod
    public void topicStateUpdate(@WebParam(name="topicId") int var1, @WebParam(name="state") boolean var2, @WebParam(name="packageMode") boolean var3) throws BGException;

    @WebMethod
    public void topicAutocloseUpdate(@WebParam(name="topicId") int var1, @WebParam(name="autoclose") boolean var2) throws BGException;

    @WebMethod
    public void topicCategorySubcategoryUpdate(@WebParam(name="topicId") int var1, @WebParam(name="categoryId") int var2, @WebParam(name="subcategoryId") int var3) throws BGException;

    @WebMethod
    public void topicBindSet(@WebParam(name="topicId") int var1, @WebParam(name="userId") String var2) throws BGException;

    @WebMethod
    public void topicPackageStateSet(@WebParam(name="contractId") int var1, @WebParam(name="topicId") int var2, @WebParam(name="include") Boolean var3) throws BGException;

    @WebMethod
    public void messageCommentUpdate(@WebParam(name="messageId") int var1, @WebParam(name="comment") String var2) throws BGException;

    @WebMethod
    public void messageAdminReadSet(@WebParam(name="messageId") int var1) throws BGException;

    @WebMethod
    public ContractModeDTO contractModeGet(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public void contractModeUpdate(@WebParam(name="contractId") int var1, @WebParam(name="currentModeId") String var2) throws Exception;

    @WebMethod
    public void contractGroupUpdate(@WebParam(name="contractId") int var1, @WebParam(name="groupId") int var2) throws Exception;

    @WebMethod
    public String getContractCurrentMode(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public List<KeyValue> getModeList() throws BGException;

    @WebMethod
    public MapHolder<String, String> getParams(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public void setParams(@WebParam(name="contractId") int var1, @WebParam(name="properties") MapHolder<String, String> var2) throws BGException;

    @WebMethod
    public SearchResult<IdTitle> groupList(@WebParam(name="groupForDirectory") boolean var1, @WebParam(name="contractId") int var2, @WebParam(name="page") Page var3) throws Exception;

    @WebMethod
    public void groupUpdate(@WebParam(name="groupId") int var1, @WebParam(name="title") String var2) throws BGException;

    @WebMethod
    public void subcategoryUpdate(@WebParam(name="subcategoryId") int var1, @WebParam(name="title") String var2) throws BGException;

    @WebMethod
    public void subcategoryDelete(@WebParam(name="subcategoryId") int var1) throws BGException;

    @WebMethod
    public Message messageGet(@WebParam(name="contractId") int var1, @WebParam(name="topicId") int var2, @WebParam(name="messageId") int var3) throws BGException;

    @WebMethod
    public SearchResult<Message> searchTopicMessages(@WebParam(name="contractId") int var1, @WebParam(name="topicId") int var2, @WebParam(name="sort") String[] var3, @WebParam(name="page") Page var4) throws BGException;

    @WebMethod
    public List<FileInfo> getMessageFileList(@WebParam(name="messageId") int var1) throws BGException;

    @WebMethod
    public SearchResult<Package> packageList(@WebParam(name="status") Boolean var1, @WebParam(name="page") Page var2) throws BGException;
}

