/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.TariffCounterPanel;
import ru.bitel.bgbilling.kernel.tariff.client.TariffVariablePanel;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class EntityTariffsPropertiesPanel
extends BGUPanel {
    private int entityId = 0;
    private Set<Integer> deleted = new HashSet<Integer>();
    private EntityTariffTableModel entityTariffTableModel = null;
    private TariffCounterPanel tariffCounterPanel = new TariffCounterPanel();
    private TariffVariablePanel tariffVariablePanel = new TariffVariablePanel();

    public EntityTariffsPropertiesPanel() {
        super(new GridBagLayout());
    }

    public EntityTariffsPropertiesPanel(ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
    }

    @Override
    protected void jbInit() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> {
            if ("newItem".equals(e.getActionCommand())) {
                this.performAction("new");
            } else if ("editItem".equals(e.getActionCommand())) {
                this.performAction("edit");
            } else if ("deleteItem".equals(e.getActionCommand())) {
                this.performAction("delete");
            }
        });
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.entityTariffTableModel = new EntityTariffTableModel();
        BGUTable table = new BGUTable(this.entityTariffTableModel);
        table.setSelectionMode(0);
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, new JScrollPane(table), (Component)this.getTariffExtraPanel(), 500L);
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleMouseClicked(table, e -> this.tableMouseClicked((MouseEvent)e));
    }

    private void tableMouseClicked(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            ContractTariff contractTariff = (ContractTariff)this.entityTariffTableModel.getSelectedRow();
            this.tariffVariablePanel.showTariffVariables(contractTariff != null ? contractTariff.getId() : 0);
            this.tariffCounterPanel.showTariffCounters(contractTariff != null ? contractTariff.getId() : 0);
            if (event.getClickCount() == 2) {
                this.performAction("edit");
            }
        }
    }

    private JPanel getTariffExtraPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)this.tariffVariablePanel, "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435");
        tabbedPane.add((Component)this.tariffCounterPanel, "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0438");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void reset() {
        this.entityTariffTableModel.setData(new ArrayList());
        this.tariffVariablePanel.reset();
    }

    public void setData() {
        this.tryCall(() -> this.entityTariffTableModel.setData(((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffList(((ClientContext)this.getContext()).getContractId(), false, ((ClientContext)this.getContext()).getModuleId(), this.entityId)));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> new TariffEditorDialog("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d", new ContractTariff().setId(-1).setPosition(0).setContractId(((ClientContext)this.getContext()).getContractId()).setPeriod(new Period(LocalDate.now(), null))).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.entityTariffTableModel.optSelectedRow().ifPresentOrElse(a -> new TariffEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430", (ContractTariff)a).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            ContractTariff contractTariff = (ContractTariff)this.entityTariffTableModel.getSelectedRow();
            if (contractTariff == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
                return;
            }
            if (ClientUtils.confirmDelete("\u0442\u0430\u0440\u0438\u0444")) {
                this.deleted.add(contractTariff.getId());
                this.entityTariffTableModel.deleteRow(contractTariff);
                this.tariffVariablePanel.clearContractTariffVars();
                this.tariffVariablePanel.doFilterTariffVariables();
            }
        });
    }

    public void newItem() {
    }

    public boolean updateData() {
        for (Integer id : this.deleted) {
            this.tryCall(() -> ((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffDelete(id));
        }
        this.deleted.clear();
        for (ContractTariff contractTariff : this.entityTariffTableModel.getRows()) {
            this.tryCall(() -> {
                contractTariff.setEntityId(this.entityId);
                contractTariff.setEntityModuleId(((ClientContext)this.getContext()).getModuleId());
                ((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffUpdate(contractTariff);
            });
        }
        EventBus.publish((Object)new UpdateContractTreeEvent(((ClientContext)this.getContext()).getModuleId(), ((ClientContext)this.getContext()).getContractId()));
        return true;
    }

    class EntityTariffTableModel
    extends BGTableModel<ContractTariff> {
        private Directory<TariffPlan> tariffPlanDirectory;

        public EntityTariffTableModel() {
            super(EntityTariffTableModel.class.getName());
            this.tariffPlanDirectory = null;
            try {
                this.tariffPlanDirectory = ((ClientContext)EntityTariffsPropertiesPanel.this.getContext()).getDirectory(TariffPlan.class, 0);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u041f#ID", 50, 50, 50, "tariffPlanId", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u043e\u0437\u0438\u0446\u0438\u044f", 50, 75, 100, "position", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, 300, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 300, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(ContractTariff contractTariff, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                TariffPlan tariffPlan = this.tariffPlanDirectory.get(contractTariff.getTariffPlanId());
                return tariffPlan != null ? tariffPlan.getTitle() : "<\u0422\u0410\u0420\u0418\u0424 \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d>";
            }
            return super.getValue(contractTariff, column);
        }
    }

    class TariffEditorDialog
    extends BGEditorDialog<ContractTariff> {
        private List<IdTitle> tariffData;
        private BGIntTextField tariffPos;
        private BGTextArea comment;
        private BGUList<IdTitle> tariffs;
        private JCheckBox useFilterFlag;
        private JCheckBox showUsedOnlyFlag;
        private BGControlPanelPeriodNoB tariffPeriod;

        public TariffEditorDialog(String title, ContractTariff data) {
            super(title, data);
            this.tariffData = new ArrayList<IdTitle>();
            this.tariffPos = new BGIntTextField();
            this.comment = new BGTextArea(7, 20);
            this.tariffs = new BGUList();
            this.useFilterFlag = new JCheckBox("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
            this.showUsedOnlyFlag = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435");
            this.tariffPeriod = new BGControlPanelPeriodNoB(false);
        }

        @Override
        public void doDialogPanel() {
            this.tariffPos.setMinValue(0L);
            this.tariffPos.setMaxValue(1000L);
            this.showUsedOnlyFlag.setSelected(true);
            this.useFilterFlag.setSelected(true);
            ActionListener al = e -> this.getPlans();
            this.showUsedOnlyFlag.addActionListener(al);
            this.useFilterFlag.addActionListener(al);
            this.panel.add((Component)this.getTariffPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getTariffParamPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.getPlans();
            this.tariffPos.setText(String.valueOf(((ContractTariff)this.data).getPosition()));
            this.tariffPeriod.setPeriod(((ContractTariff)this.data).getPeriod());
            this.comment.setText(((ContractTariff)this.data).getComment());
            this.tariffs.setEnabled(((ContractTariff)this.data).getId() < 1);
            ClientUtils.setListSelection(this.tariffs, ((ContractTariff)this.data).getTariffPlanId(), -1);
        }

        @Override
        public boolean doApply() throws Exception {
            IdTitle tariffItem = (IdTitle)this.tariffs.getSelectedValue();
            if (tariffItem == null || tariffItem.getId() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444");
                return false;
            }
            String pos = this.tariffPos.getText();
            if (Utils.isBlankString(pos)) {
                pos = "0";
            }
            ((ContractTariff)this.data).setPosition(Utils.parseInt(pos));
            ((ContractTariff)this.data).setPeriod(this.tariffPeriod.getPeriod());
            ((ContractTariff)this.data).setTariffPlanId(tariffItem.getId());
            ((ContractTariff)this.data).setComment(this.comment.getText());
            if (((ContractTariff)this.data).getId() < 0) {
                ((ContractTariff)this.data).setId(0);
                EntityTariffsPropertiesPanel.this.entityTariffTableModel.getRows().add((ContractTariff)this.data);
            }
            EntityTariffsPropertiesPanel.this.entityTariffTableModel.fireTableDataChanged();
            return true;
        }

        private JPanel getTariffPanel() {
            JPanel checkBoxPanel = new JPanel(new GridBagLayout());
            checkBoxPanel.add((Component)this.showUsedOnlyFlag, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            checkBoxPanel.add((Component)this.useFilterFlag, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.tariffs), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 1, new Insets(2, 5, 0, 0), 0, 0));
            panel.add((Component)checkBoxPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getTariffParamPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.tariffPos, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.tariffPeriod, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 5, 0, 0), 0, 0));
            return panel;
        }

        private void getPlans() {
            Request request = new Request().setModule("contract").setAction("ContractTariffPlan").setAttribute("id", ((ContractTariff)this.data).getId()).setAttribute("showUsed", this.showUsedOnlyFlag.isSelected() ? 1 : 0).setAttribute("useFilter", this.useFilterFlag.isSelected() ? 1 : 0).setContractId(((ClientContext)EntityTariffsPropertiesPanel.this.getContext()).getContractId()).setAttribute("mid", ((ClientContext)EntityTariffsPropertiesPanel.this.getContext()).getModuleId());
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.tryCall(() -> {
                    this.tariffData.clear();
                    XMLUtils.selectElements(doc, "//tariffPlans/item").forEach(a -> this.tariffData.add(new IdTitle(Utils.parseInt(a.getAttribute("id")), a.getAttribute("title"))));
                    this.tariffs.setData(this.tariffData);
                    ClientUtils.setListSelection(this.tariffs, ((ContractTariff)this.data).getTariffPlanId(), -1);
                });
            }
        }
    }
}

