/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.server.util;

import bitel.billing.server.radius.RadiusAttribute;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.ARPUtil;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class RadiusUtil {
    private static Logger log = LogManager.getLogger();
    private String accountHost = null;
    private String authHost = null;
    private int accountPort = 0;
    private int authPort = 0;
    private byte[] secret = null;
    private String nasId = null;
    private static int identifier = 0;

    public RadiusUtil() {
        Setup setup = GlobalConfig.getGlobalConfig().getSetup();
        this.initRadiusInfo(setup);
    }

    private void initRadiusInfo(Setup setup) {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        this.authHost = cfg.getAuthHost();
        this.accountHost = cfg.getAccountHost();
        this.authPort = cfg.getAuthPort();
        this.accountPort = cfg.getAccountPort();
        this.secret = cfg.getSecret();
        this.nasId = cfg.getNasId();
        log.debug("portal init..");
        log.debug("authHost = " + this.authHost);
        log.debug("accountHost = " + this.accountHost);
        log.debug("authPort = " + this.authPort);
        log.debug("accountPort = " + this.accountPort);
        log.debug("secret = " + String.valueOf(this.secret));
        log.debug("nasId = " + this.nasId);
    }

    public RadiusPacket authUser(String login, String passwd, String ip, String realm, String acctSessionId) {
        RadiusPacket result = null;
        try {
            RadiusPacket packet = this.makeAuthPacket(login, passwd, ip, realm, this.secret, this.nasId, acctSessionId);
            result = this.sendPacket(packet, this.authHost, this.authPort);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Integer getIntAtrrubuteValue(RadiusPacket authPacket, int vendorcode, int attrCode) {
        Integer result = null;
        try {
            result = authPacket.getIntAttribute(vendorcode, attrCode, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public byte[] getByteAtrrubuteValue(RadiusPacket authPacket, int vendorcode, int attrCode) {
        byte[] result = null;
        try {
            result = authPacket.getByteAttribute(vendorcode, vendorcode, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getStringAtrrubuteValue(RadiusPacket authPacket, int vendorcode, int attrCode) {
        String result = null;
        try {
            result = authPacket.getStringAttribute(vendorcode, attrCode, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean sendStartPacket(String login, String ip, String acctSessionId) {
        boolean result = false;
        try {
            RadiusPacket packet = RadiusUtil.makePacket(login, (byte)4, ip, this.secret, this.nasId, acctSessionId);
            packet.setIntAttribute(-1, 40, 1);
            RadiusPacket response = this.sendPacket(packet, this.accountHost, this.accountPort);
            result = response.getCode() == 5;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean sendStopPacket(String login, String ip, long startTime, String acctSessionId) {
        boolean result = false;
        try {
            RadiusPacket packet = RadiusUtil.makePacket(login, (byte)4, ip, this.secret, this.nasId, acctSessionId);
            long delta = System.currentTimeMillis() - startTime;
            packet.setIntAttribute(-1, 40, 2);
            packet.setIntAttribute(-1, 46, (int)(delta / 1000L));
            RadiusPacket response = this.sendPacket(packet, this.accountHost, this.accountPort);
            result = response.getCode() == 5;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean sendUpdatePacket(String login, String ip, long inputOctets, long outputOctetets, String acctSessionId, long startTime) {
        boolean result = false;
        try {
            RadiusPacket packet = RadiusUtil.makePacket(login, (byte)4, ip, this.secret, this.nasId, acctSessionId);
            packet.setIntAttribute(-1, 40, 3);
            int inputGigaWords = (int)(inputOctets >> 32);
            int outputGigaWords = (int)(outputOctetets >> 32);
            packet.setIntAttribute(-1, 52, inputGigaWords);
            packet.setIntAttribute(-1, 53, outputGigaWords);
            int input = (int)(inputOctets & 0xFFFFFFFFL);
            int output = (int)(outputOctetets & 0xFFFFFFFFL);
            packet.setIntAttribute(-1, 42, input);
            packet.setIntAttribute(-1, 43, output);
            long delta = System.currentTimeMillis() - startTime;
            packet.setIntAttribute(-1, 46, (int)(delta / 1000L));
            RadiusPacket response = this.sendPacket(packet, this.accountHost, this.accountPort);
            result = response.getCode() == 5;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private RadiusPacket sendPacket(RadiusPacket packet, String hostName, int port) throws SocketException, UnknownHostException, IOException, NoSuchAlgorithmException, InvalidKeyException, BGException {
        ByteBuffer bb = ByteBuffer.allocate(4096);
        packet.write(bb, this.secret);
        byte[] outBytes = bb.array();
        DatagramSocket socket = new DatagramSocket();
        socket.setSoTimeout(9000);
        InetAddress address = InetAddress.getByName(hostName);
        DatagramPacket outPacket = new DatagramPacket(outBytes, bb.limit(), address, port);
        DatagramPacket packetIn = new DatagramPacket(new byte[4096], 4096);
        socket.send(outPacket);
        socket.receive(packetIn);
        socket.close();
        RadiusPacket response = RadiusPacket.parse(ByteBuffer.wrap(packetIn.getData()));
        return response;
    }

    private RadiusPacket makeAuthPacket(String login, String passwd, String ip, String realm, byte[] secret, String nasId, String acctSessionId) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        RadiusPacket packet = RadiusUtil.makePacket((String)login, (byte)1, ip, secret, nasId, acctSessionId);
        if (!Utils.isEmptyString(realm)) {
            login = (String)login + "@" + realm;
        }
        RadiusUtils.setPapPassword(packet, secret, passwd);
        return packet;
    }

    private static RadiusPacket makePacket(String login, byte code, String ip, byte[] secret, String nasId, String acctSessionId) {
        RadiusPacket packet = new RadiusPacket(code, (byte)(++identifier % 256 & 0xFF));
        RadiusAttribute atr = new RadiusAttribute(32);
        atr.setStringValue(nasId);
        packet.setStringAttribute(-1, 32, nasId);
        packet.setIntAttribute(-1, 5, WiFiUtil.getIp(ip));
        packet.setStringAttribute(-1, 44, acctSessionId);
        packet.setStringAttribute(-1, 1, login);
        packet.setIntAttribute(-1, 8, WiFiUtil.getIp(ip));
        String mac = ARPUtil.getMACForIp(ip);
        if (mac != null) {
            packet.setStringAttribute(-1, 31, mac);
        }
        return packet;
    }
}

