/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.common;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntCount
extends JTextField {
    public IntCount(int columns) {
        super(columns);
        this.setHorizontalAlignment(0);
        this.setInputVerifier(new InputVerifier(this){

            @Override
            public boolean verify(JComponent input) {
                return ((JTextField)input).getText().matches("^\\d*$");
            }
        });
        this.setDocument(new IntDocument());
    }

    class IntDocument
    extends PlainDocument {
        IntDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (i == 0 && source[i] == '-' && offs == 0) {
                    result[j++] = source[i];
                    continue;
                }
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

