/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.service;

import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.uniteller.common.bean.Transaction;
import ru.bitel.bgbilling.modules.uniteller.common.service.UnitellerService;
import ru.bitel.bgbilling.modules.uniteller.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.uniteller.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerAutopaymentEvent;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerCheckEvent;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerSumEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.uniteller.common.service.UnitellerService")
public class UnitellerServiceImpl
extends AbstractService
implements UnitellerService {
    @Resource
    private ContractAutopaymentService contractAutopaymentService;

    private TransactionManager getTransactionManager() {
        return new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult transactionSearchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage(), searchParam.getSort());
            this.getTransactionManager().searchTransaction(transactionSearchResult, searchParam);
            return transactionSearchResult;
        });
    }

    public void checkTransactions(int contractId) throws BGException {
        EventProcessor.getInstance().publish((Event)new UnitellerCheckEvent(this.moduleId, contractId));
    }

    public Autopayment autopaymentGet(int contractId) throws BGException {
        return (Autopayment)this.tryReturn(() -> new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId));
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException {
        this.beginAutopaymentTransaction(contractId, amount, url, mode, paramsHolder, null);
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder, ContractAutopaymentMode autopaymentMode) throws BGException {
        this.tryCall(() -> {
            boolean fiscalization;
            if (contractId <= 0 && this.moduleId <= 0) {
                throw new BGIllegalArgumentException();
            }
            BigDecimal sum = Optional.ofNullable(amount).map(a -> a.setScale(2, RoundingMode.HALF_EVEN)).orElse(null);
            if (sum == null || sum.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
            }
            if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
                throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.", "contractModule.notEnabled");
            }
            if (mode != null) {
                mode.value = "post";
            }
            ModuleSetup moduleSetup = this.getModuleSetup();
            UnitellerSumEvent event = new UnitellerSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((UnitellerSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
            if (autopaymentMode == null) {
                BigDecimal sumMin = moduleSetup.getBigDecimal("uniteller.sum.min", new BigDecimal(100));
                BigDecimal sumMax = moduleSetup.getBigDecimal("uniteller.sum.max", new BigDecimal(5000));
                if (sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                    throw new BGException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
                }
            }
            Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
            String successUrl = (String)params.get("successUrl");
            String failureUrl = (String)params.get("failureUrl");
            if (Utils.isBlankString((String)successUrl)) {
                successUrl = moduleSetup.get("uniteller.url.return.ok", "");
            }
            if (Utils.isBlankString((String)failureUrl)) {
                failureUrl = moduleSetup.get("uniteller.url.return.no", "");
            }
            int autopaymentId = 0;
            if (autopaymentMode != null) {
                Autopayment autopayment;
                if (autopaymentMode.getMode() != AutopaymentMode.OFF) {
                    this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, autopaymentMode);
                }
                if ((autopayment = AutopaymentManager.registerAutopayment((Connection)this.getConnection(), (int)this.moduleId, (AbstractAutopaymentManager)new AutopaymentManager(this.getConnection(), this.moduleId), (int)contractId, (ContractAutopaymentMode)autopaymentMode, null)) != null && autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentId = autopayment.getId();
                }
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
            String description = "";
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId));
            description = moduleSetup.get("uniteller.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractRuntime.getContractTitle());
            Transaction transaction = new Transaction().setSum(sum).setContractId(contractId).setCreateDate(new Date()).setTransactionId(String.valueOf(System.currentTimeMillis() + (long)(100.0 * Math.random()))).setParameters(autopaymentId > 0 ? "autopaymentId=" + autopaymentId : null);
            transactionManager.update(transaction);
            DecimalFormat decimalFormat = new DecimalFormat("###########0.00");
            String sumString = decimalFormat.format(sum).replace(",", ".");
            dataMap.put("Shop_IDP", moduleSetup.get("uniteller.point.id", ""));
            dataMap.put("Order_IDP", String.valueOf(transaction.getTransactionId()));
            dataMap.put("Subtotal_P", sumString);
            dataMap.put("Lifetime", moduleSetup.get("uniteller.lifetime", String.valueOf(3600)));
            dataMap.put("Comment", description);
            dataMap.put("URL_RETURN_OK", successUrl);
            dataMap.put("URL_RETURN_NO", failureUrl);
            if (autopaymentId > 0) {
                dataMap.put("IsRecurrentStart", "1");
            }
            String receiptSignature = null;
            String receipt = null;
            if (moduleSetup.getBoolean("uniteller.fiscalization.enable", false)) {
                JSONObject customerJSON = new JSONObject();
                customerJSON.put("id", (Object)contractRuntime.getContractTitle());
                String customerAddress = (String)params.get("receiptTo");
                if (!Utils.isBlankString((String)customerAddress)) {
                    if (customerAddress.contains("@")) {
                        customerJSON.put("email", (Object)customerAddress);
                    } else {
                        customerJSON.put("phone", (Object)customerAddress);
                    }
                }
                JSONObject lineJSON = new JSONObject().put("name", (Object)moduleSetup.get("uniteller.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractRuntime.getContractTitle())).put("price", (Object)sum).put("qty", moduleSetup.getInt("uniteller.fiscalization.receipt.qty", 1)).put("sum", (Object)sum).put("vat", moduleSetup.getInt("uniteller.fiscalization.receipt.vat", 0)).put("taxmode", moduleSetup.getInt("uniteller.fiscalization.receipt.taxmode", 0));
                JSONArray linesJSON = new JSONArray().put((Object)lineJSON);
                JSONObject receiptJSON = new JSONObject().put("customer", (Object)customerJSON).put("lines", (Object)linesJSON).put("total", (Object)sum);
                receipt = receiptJSON.toString();
                try {
                    dataMap.put("Receipt", Base64.getEncoder().encodeToString(receipt.getBytes("UTF-8")));
                }
                catch (Exception e2) {
                    this.getLogger().error(e2.getMessage(), (Throwable)e2);
                }
                receiptSignature = new StringBuffer().append(Utils.getDigest((String)String.valueOf(dataMap.get("Shop_IDP")), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(dataMap.get("Order_IDP")), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(dataMap.get("Subtotal_P")), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(dataMap.get("Receipt")), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)moduleSetup.get("uniteller.password", ""), (String)"ASCII", (String)"SHA-256").toLowerCase()).toString();
                dataMap.put("ReceiptSignature", Utils.getDigest((String)receiptSignature, (String)"ASCII", (String)"SHA-256"));
            }
            String signature = new StringBuffer().append(Utils.getDigest((String)String.valueOf(dataMap.get("Shop_IDP")), (String)"ASCII").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(dataMap.get("Order_IDP")), (String)"ASCII").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(dataMap.get("Subtotal_P")), (String)"ASCII").toLowerCase()).append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append(Utils.getDigest((String)String.valueOf(dataMap.get("Lifetime")), (String)"ASCII").toLowerCase()).append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append(Utils.getDigest((String)moduleSetup.get("uniteller.password", ""), (String)"ASCII").toLowerCase()).toString();
            dataMap.put("Signature", Utils.getDigest((String)signature, (String)"ASCII"));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Shop_IDP: " + String.valueOf(dataMap.get("Shop_IDP")));
                this.getLogger().debug("Order_IDP: " + String.valueOf(dataMap.get("Order_IDP")));
                this.getLogger().debug("Subtotal_P: " + String.valueOf(dataMap.get("Subtotal_P")));
                this.getLogger().debug("Lifetime: " + String.valueOf(dataMap.get("Lifetime")));
                this.getLogger().debug("Comment: " + String.valueOf(dataMap.get("Comment")));
                this.getLogger().debug("URL_RETURN_OK: " + String.valueOf(dataMap.get("URL_RETURN_OK")));
                this.getLogger().debug("URL_RETURN_NO: " + String.valueOf(dataMap.get("URL_RETURN_NO")));
                this.getLogger().debug("Signature: " + String.valueOf(dataMap.get("Signature")) + " => " + signature);
                if (moduleSetup.getBoolean("uniteller.fiscalization.enable", false)) {
                    this.getLogger().debug("Receipt: " + String.valueOf(dataMap.get("Receipt")) + " => " + receipt);
                    this.getLogger().debug("ReceiptSignature: " + String.valueOf(dataMap.get("ReceiptSignature")) + " => " + receiptSignature);
                }
            }
            url.value = ((fiscalization = moduleSetup.getBoolean("uniteller.fiscalization.enable", false)) ? moduleSetup.get("uniteller.fiscalization.url.gate", "https://fpay.uniteller.ru/v2/") : moduleSetup.get("uniteller.url.gate", "https://wpay.uniteller.ru/")) + "pay";
            if (paramsHolder != null) {
                paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
            }
        });
    }

    public void autopaymentDeactivate(int contractId) throws BGException {
        this.tryCall(() -> AutopaymentManager.unregisterAutopayment((Connection)this.getConnection(), (int)contractId, (AbstractAutopaymentManager)new AutopaymentManager(this.getConnection(), this.moduleId), (int)contractId));
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(period, page, sort);
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
            autopaymentManager.searchAutopayment(searchResult, contractId);
            return searchResult;
        });
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("doManualAutopayment [contractId = {}, sum = {}]", (Object)contractId, (Object)sum);
        }
        if (contractId > 0) {
            this.tryCall(() -> {
                Autopayment autopayment = new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("autopayment = {}", (Object)autopayment);
                    this.getLogger().debug("autopayment.getMode() = {}", (Object)autopayment.getMode());
                }
                if (autopayment != null && autopayment.getMode() == AutopaymentMode.AUTO && sum != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Publish UnitellerAutopaymentEvent [moduleId = {}, contractId = {}, sum = {}]", new Object[]{this.moduleId, contractId, sum});
                    }
                    EventProcessor.getInstance().publish((Event)new UnitellerAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO, sum));
                }
            });
        }
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return null;
    }
}

