/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.service;

import jakarta.activation.DataHandler;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.MTOM;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContractContact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.CustomDyncodeChecker;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchFileStorageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchMessageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SenderTypeDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SubscriptionDao;
import ru.bitel.bgbilling.plugins.dispatch.server.event.DispatchEvent;
import ru.bitel.bgbilling.plugins.dispatch.server.event.DispatchSubscriptionEvent;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.bgbilling.plugins.dispatch.server.utils.DispatchUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService")
@MTOM
public class DispatchServiceImpl
extends AbstractService
implements DispatchService {
    private ContactDao contactDao;
    private DispatchDao dispatchDao;
    private SenderTypeDao senderTypeDao;
    private ContactTypeDao contactTypeDao;
    private SubscriptionDao subscriptionDao;
    private DispatchMessageDao dispatchMessageDao;
    private DispatchFileStorageDao dispatchFileStorageDao;
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
    @Resource
    ModuleService moduleService;

    public List<Dispatch> getDispatchList() throws BGException {
        return (List)this.tryReturn(() -> this.getDispatchDao().getList());
    }

    public List<DispatchMessage> getMessageList(int did, boolean onlyNotSent) throws BGException {
        return (List)this.tryReturn(() -> this.getDispatchMessageDao().getList(did, onlyNotSent));
    }

    public void updateDispatch(Dispatch dispatch) throws BGException {
        this.tryCall(() -> {
            boolean isCreated = true;
            if (dispatch.getId() > 0) {
                Dispatch old = (Dispatch)this.getDispatchDao().get(dispatch.getId());
                if (old != null && old.getContactTypeId() != dispatch.getContactTypeId()) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432 \u0443 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438.");
                }
                isCreated = false;
            }
            dispatch.setUserId(this.userId);
            this.getDispatchDao().update(dispatch);
            EventProcessor.getInstance().publishAfterCommit((Event)new DispatchEvent(this.plugin.getPluginUID(), dispatch, isCreated, this.userId));
        });
    }

    public void updateMessage(DispatchMessage dispatchMessage) throws BGException {
        this.tryCall(() -> {
            DispatchMessage old;
            if (dispatchMessage.getId() > 0 && (old = (DispatchMessage)this.getDispatchMessageDao().get(dispatchMessage.getId())).isSent()) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
            this.getDispatchMessageDao().update(dispatchMessage);
        });
    }

    public void deleteDispatch(Dispatch d) throws BGException {
        this.tryCall(() -> {
            this.getDispatchFileStorageDao().deleteByObject((Id)d);
            this.getDispatchMessageDao().deleteByDispatch(d.getId());
            this.getSubscriptionDao().deleteByDispatch(d.getId());
            this.getDispatchDao().delete(d.getId());
        });
    }

    public void deleteMessage(DispatchMessage dm) throws BGException {
        this.tryCall(() -> {
            DispatchMessage old;
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
            if (dm.getId() > 0 && (old = (DispatchMessage)this.getDispatchMessageDao().get(dm.getId())) != null && old.isSent() && plugin.getSetup().getBoolean("allow.delete.sent.messages", false)) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
            this.getDispatchFileStorageDao().deleteByObject((Id)dm);
            this.getDispatchMessageDao().delete(dm.getId());
        });
    }

    public void addMessageInclusion(DispatchMessage dm, Holder<DataHandler> inclusion, String fileName) throws BGException {
        this.tryCall(() -> {
            if (dm.isSent()) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0432 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
            byte[] bytes = Utils.readByBlock((InputStream)((DataHandler)inclusion.value).getInputStream());
            this.getDispatchFileStorageDao().uploadFile((Id)dm, fileName, bytes);
        });
    }

    public void deleteMessageInclusion(DispatchMessage dm, BGServerFile inclusion) throws BGException {
        if (dm.isSent()) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0438\u0437 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
        }
        if (inclusion == null) {
            this.getDispatchFileStorageDao().deleteByObject((Id)dm);
        } else {
            this.getDispatchFileStorageDao().deleteFile(inclusion.getId());
        }
    }

    public List<BGServerFile> getMessageInclusions(DispatchMessage dm) throws BGException {
        return this.getDispatchFileStorageDao().getFileList((Id)dm);
    }

    public void updateContactType(ContactType current) throws BGException {
        this.tryCall(() -> this.getContactTypeDao().update(current));
    }

    public void deleteContactType(int contactTypeId) throws BGException {
        this.tryCall(() -> {
            if (this.getDispatchDao().checkByContactType(contactTypeId)) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432: \u0435\u0441\u0442\u044c \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0441 \u0442\u0430\u043a\u0438\u043c \u0442\u0438\u043f\u043e\u043c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432");
            }
            this.getContactDao().deleteByType(contactTypeId);
            this.getContactTypeDao().delete(contactTypeId);
        });
    }

    public List<ContactType> getContactTypes() throws BGException {
        return (List)this.tryReturn(() -> this.getContactTypeDao().getList());
    }

    @Deprecated
    public List<Contact> getContacts(int contractId) throws BGException {
        return (List)this.tryReturn(() -> this.getContactDao().getContactsOfContract(contractId));
    }

    public List<Contact> getContacts(int contractId, Dispatch dispatch) throws BGException {
        return (List)this.tryReturn(() -> {
            int typeId;
            List<Contact> contacts = this.getContactDao().getContactsOfContract(contractId);
            int contactTypeId = dispatch.getContactTypeId();
            if (Utils.notEmptyCollection(contacts)) {
                contacts.removeIf(contact -> contact.getContactTypeId() != contactTypeId);
            }
            if (Utils.isEmptyCollection(contacts) && ((typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, this.getConnection())) == ContractParameterPrefType.TYPE_PHONE.getId() || typeId == ContractParameterPrefType.TYPE_EMAIL.getId())) {
                return DispatchUtils.getContactsFromContractParameters(contractId, dispatch, this.getConnection());
            }
            return contacts;
        });
    }

    public List<ContractContact> getContracts(String name, int typeId) throws BGException {
        return (List)this.tryReturn(() -> this.getContactDao().getContracts(name, typeId));
    }

    public void updateContact(Contact current) throws BGException {
        this.tryCall(() -> {
            ContactType type = this.getContactTypeDao().get(current.getContactTypeId());
            if ((Utils.notBlankString((String)current.getValue()) || Utils.isBlankString((String)current.getValue()) && type.getPid() <= 0) && Utils.notBlankString((String)type.getPattern()) && !Pattern.matches(type.getPattern(), current.getValue())) {
                throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430!");
            }
            this.getContactDao().update(current);
        });
    }

    public void deleteContact(int id) throws BGException {
        this.tryCall(() -> {
            if (this.getSubscriptionDao().isContactSubscribed(id)) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            this.getContactDao().delete(id);
        });
    }

    public List<Subscription> getSubscriptions(int dispatchId, int contractId) throws BGException {
        return (List)this.tryReturn(() -> this.getSubscriptionDao().getList(dispatchId, contractId, null));
    }

    public List<Subscription> getActiveSubscriptions(int dispatchId) throws BGException {
        return (List)this.tryReturn(() -> this.getSubscriptionDao().getList(dispatchId, 0, Boolean.TRUE));
    }

    public void deleteSubscription(int subscriptionId) throws BGException {
        this.tryCall(() -> {
            Subscription s = this.getSubscriptionDao().get(subscriptionId);
            this.getSubscriptionDao().delete(subscriptionId);
            EventProcessor.getInstance().publishAfterCommit((Event)new DispatchSubscriptionEvent(this.plugin.getPluginUID(), s, false, this.userId));
        });
    }

    public void updateSubscriptions(Subscription subscription) throws BGException {
        this.tryCall(() -> {
            int typeId;
            Dispatch dispatch = subscription.getDispatch();
            if (subscription.getContacts() != null && subscription.getContacts().size() == 0 && !dispatch.isWoContactType() && (typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, this.getConnection())) != ContractParameterPrefType.TYPE_PHONE.getId() && typeId != ContractParameterPrefType.TYPE_EMAIL.getId()) {
                throw new BGMessageException("\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b!");
            }
            if (subscription.getContacts().size() > 1 && this.getDispatchDao().isOnlyOneContact(dispatch.getId())) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430!");
            }
            boolean isNotSubscribedYet = subscription.getId() <= 0;
            this.getSubscriptionDao().update(subscription);
            if (this.plugin.getSetup().getBoolean("dispatch.email.unsubscribe", false) && subscription.getDispatch().getSenderType().getId() == -1) {
                this.getSubscriptionDao().generateHashes(subscription);
            }
            if (isNotSubscribedYet) {
                EventProcessor.getInstance().publishAfterCommit((Event)new DispatchSubscriptionEvent(this.plugin.getPluginUID(), subscription, true, this.userId));
            }
        });
    }

    public void addSubscriptions(String dispatchIds, String contractIds) throws BGException {
        this.tryCall(() -> {
            for (Integer dispatchId : Utils.toIntegerList((String)dispatchIds)) {
                Dispatch dispatch = (Dispatch)this.getDispatchDao().get(dispatchId);
                if (dispatch == null) continue;
                for (Integer cid : Utils.toIntegerList((String)contractIds)) {
                    List<Subscription> contractSubscriptions = this.getSubscriptions(dispatchId, cid);
                    if (!contractSubscriptions.isEmpty()) continue;
                    ArrayList<Contact> subscriptionContacts = new ArrayList<Contact>();
                    for (Contact contact : this.getContacts(cid)) {
                        if (contact.getContactTypeId() != dispatch.getContactTypeId()) continue;
                        subscriptionContacts.add(contact);
                    }
                    if (!subscriptionContacts.isEmpty()) {
                        this.addSubscriptionOnContract(dispatch, cid, subscriptionContacts);
                        continue;
                    }
                    Contact contact = this.addDefaultContact(dispatch, cid);
                    if (contact == null) continue;
                    this.addSubscriptionOnContract(dispatch, cid, Collections.singletonList(contact));
                }
            }
        });
    }

    private Contact addDefaultContact(Dispatch dispatch, int cid) throws BGException {
        return (Contact)this.tryReturn(() -> {
            ContactType contactType = this.getContactTypeDao().get(dispatch.getContactTypeId());
            if (contactType != null && contactType.getPid() > 0) {
                Contact contact = new Contact();
                contact.setContactTypeId(dispatch.getContactTypeId());
                contact.setContractId(cid);
                contact.setValue("");
                this.updateContact(contact);
                return contact;
            }
            return null;
        });
    }

    private void addSubscriptionOnContract(Dispatch dispatch, int contractId, List<Contact> contacts) throws BGException {
        Subscription subscription = new Subscription().setActive(true).setContractId(contractId).setDispatch(dispatch).setPreferences(new Preferences()).setComment("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u043e\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438").setContacts(contacts).setSubscriptionPeriod(new Period(new Date(), null));
        this.updateSubscriptions(subscription);
    }

    public List<SenderType> getSenderTypes() throws BGException {
        return (List)this.tryReturn(() -> this.getSenderTypeDao().getList());
    }

    public String getSenderIfaceClassName() {
        return Sender.class.getCanonicalName();
    }

    public void updateSenderType(SenderType current) throws BGException {
        this.tryCall(() -> {
            if (current.getId() < 0) {
                throw new BGIllegalArgumentException();
            }
            this.getSenderTypeDao().update(current);
        });
    }

    public void deleteSenderType(int id) throws BGException {
        this.tryCall(() -> {
            if (id <= 0) {
                throw new BGIllegalArgumentException();
            }
            this.getSenderTypeDao().delete(id);
        });
    }

    @Deprecated
    public List<IdTitle> getAddressParamList() throws BGException {
        return (List)this.tryReturn(() -> new ContractParameterPrefDao(this.getConnection()).getContractParameterPrefIdTitleList(2));
    }

    public String getCustomConditionCheckerIfaceName() {
        return CustomDyncodeChecker.class.getName();
    }

    public void setEventForSubscription(int dispatchId, int contractId) throws BGException {
        for (Subscription subscription : this.getSubscriptions(dispatchId, contractId)) {
            subscription.getPreferences().set("event.occured.flag", "1");
            this.updateSubscriptions(subscription);
        }
    }

    public SearchResult<DispatchMessageStatistic> getMessageStatisticList(int contractId, int dispatchId, int messageId, int contactId, Period period, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(period, page);
            this.getDispatchMessageDao().getMessageStatisticList(contractId, dispatchId, messageId, contactId, (SearchResult<DispatchMessageStatistic>)searchResult);
            return searchResult;
        });
    }

    public List<String> installedModuleList() throws BGException {
        return (List)this.tryReturn(() -> this.moduleService.installedModuleList().stream().map(BGInstalledModule::getName).collect(Collectors.toList()));
    }

    public String getContactDefaultValue(int contactTypeId, int contractId) throws BGException {
        return (String)this.tryReturn(() -> this.getContactDao().getDefaultValue(contactTypeId, contractId));
    }

    private ContactDao getContactDao() {
        this.contactDao = new ContactDao(this.getConnection());
        return Optional.ofNullable(this.contactDao).orElse(this.contactDao);
    }

    private DispatchDao getDispatchDao() {
        this.dispatchDao = new DispatchDao(this.getConnection());
        return Optional.ofNullable(this.dispatchDao).orElse(this.dispatchDao);
    }

    private SenderTypeDao getSenderTypeDao() {
        this.senderTypeDao = new SenderTypeDao(this.getConnection());
        return Optional.ofNullable(this.senderTypeDao).orElse(this.senderTypeDao);
    }

    private ContactTypeDao getContactTypeDao() {
        this.contactTypeDao = new ContactTypeDao(this.getConnection());
        return Optional.ofNullable(this.contactTypeDao).orElse(this.contactTypeDao);
    }

    private SubscriptionDao getSubscriptionDao() {
        this.subscriptionDao = new SubscriptionDao(this.getConnection());
        return Optional.ofNullable(this.subscriptionDao).orElse(this.subscriptionDao);
    }

    private DispatchMessageDao getDispatchMessageDao() {
        this.dispatchMessageDao = new DispatchMessageDao(this.getConnection());
        return Optional.ofNullable(this.dispatchMessageDao).orElse(this.dispatchMessageDao);
    }

    private DispatchFileStorageDao getDispatchFileStorageDao() {
        if (this.dispatchFileStorageDao == null) {
            try {
                this.dispatchFileStorageDao = new DispatchFileStorageDao(this.getConnection(), this.plugin);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.dispatchFileStorageDao;
    }
}

