<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">Ошибка подключения</xsl:template>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@accessCode = '-2'">
		<xsl:call-template name="module_error"/>
	</xsl:when>
	<xsl:when test="@accessCode = '-1'">
		<xsl:call-template name="connection_error"/>
	</xsl:when>
	<xsl:when test="@accessCode = '0'">
		<xsl:call-template name="code_0"/>
	</xsl:when>
	<xsl:when test="@accessCode = '1'">
		<xsl:call-template name="code_1"/>
	</xsl:when>
	<xsl:when test="@accessCode = '2'">
		<xsl:call-template name="code_2"/>
	</xsl:when>
	<xsl:when test="@accessCode = '3'">
	 	<xsl:call-template name="code_3"/>
	</xsl:when>
	<xsl:when test="@accessCode = '10'">
	 	<xsl:call-template name="code_10"/>
	</xsl:when>
	<xsl:when test="@accessCode = '11'">
	 	<xsl:call-template name="code_11"/>
	</xsl:when>
	<xsl:when test="@accessCode = '12'">
	 	<xsl:call-template name="code_12"/>
	</xsl:when>
	<xsl:when test="@accessCode = '20'">
	 	<xsl:call-template name="code_20"/>
	</xsl:when>	
	<xsl:when test="@accessCode = '40'">
	 	<xsl:call-template name="code_40"/>
	</xsl:when>
	<xsl:when test="@accessCode = '44'">
	 	<xsl:call-template name="code_44"/>
	</xsl:when>
	<xsl:when test="@accessCode = '46'">
	 	<xsl:call-template name="code_46"/>
	</xsl:when>
	<xsl:when test="@accessCode = '47'">
	 	<xsl:call-template name="code_47"/>
	</xsl:when>
	<xsl:when test="@accessCode = '62'">
	 	<xsl:call-template name="code_62"/>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="module_error">
<h2>ОШИБКА: Модуль не найден.</h2>
</xsl:template>

<xsl:template name="connection_error">
<h2>ОШИБКА: Соединение не найдено.</h2>
</xsl:template>

<xsl:template name="code_0">
<h2>Ошибка подключения отсутствует.</h2>
</xsl:template>

<xsl:template name="code_1">
<h2>ОШИБКА: Логин или номер карты не найден.</h2>
</xsl:template>

<xsl:template name="code_2">
<h2>ОШИБКА: Неверный пароль логина</h2>
		<p>Логин найден, но введённый пароль не соответствует его паролю.</p>
		<p>Уважаемый абонент! Пароль указан неправильно, проверьте раскладку ввода языковой панели (EN, отключите CapsLock) и заново наберите пароль</p>
</xsl:template>

<xsl:template name="code_3">
<h2>ОШИБКА: Превышен лимит сессий</h2>
<p>Уважаемый абонент! У данного логина установлено ограничение на число одновременных сессий. </p>
</xsl:template>

<xsl:template name="code_10">
<h2>ОШИБКА: Сервис не активен</h2>
<p>Уважаемый абонент! Статус сервиса/логина не позволяет авторизацию</p>
</xsl:template>

<xsl:template name="code_11">
<h2>ОШИБКА: Договор не активен</h2>
<p>Уважаемый абонент! Статус договора не позволяет авторизовать логин</p>
</xsl:template>

<xsl:template name="code_12">
<h2>ОШИБКА: Ошибка баланса</h2>
<p>Уважаемый абонент! Ваш баланс равен <xsl:value-of select="./contract/@balance_rest"/>. Пополнить счет можно в ближайшем платежном терминале (при оплате укажите № договора <xsl:value-of select="../contract/@title"/>) или в офисе компании Маглан. Для более подробной информации состояния Вашего счета зайдите на сайт статистики</p>
</xsl:template>

<xsl:template name="code_20">
<h2>ОШИБКА: Сервис не активен</h2>
<p>Уважаемый абонент! Статус сервиса/логина не позволяет авторизацию</p>
</xsl:template>

<xsl:template name="code_40">
<h2>ОШИБКА: Подключение запрещено</h2>
</xsl:template>

<xsl:template name="code_44">
<h2>ОШИБКА: Тарифный план отказал в авторизации</h2>
<p>Уважаемый абонент! Тарифный план не позволяет авторизовать логин</p>
</xsl:template>

<xsl:template name="code_46">
<h2>ОШИБКА: Подключение запрещено</h2>
<p>Уважаемый абонент! Подключение с данного MAC-адреса запрещено</p>
</xsl:template>

<xsl:template name="code_47">
<h2>ОШИБКА: Подключение запрещено</h2>
<p>Уважаемый абонент! Подключение с данного компьютера или точки доступа запрещено</p>
</xsl:template>

<xsl:template name="code_62">
<h2>ОШИБКА: Тарифные планы не найдены</h2>
<p>Уважаемый абонент! У договора не установлен ни один тарифный план для данного модуля на день авторизации. Обратитесь в службу технической поддержки.</p>
</xsl:template>

</xsl:stylesheet>