/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;

public class DataLogReader<D extends DataLog<D>>
implements Closeable {
    protected final D dataLog;
    private final ReadableByteChannel readableByteChannel;
    protected long readBufferPosition;
    protected final ByteBuffer readBuffer;

    protected DataLogReader(D dataLog, ByteBuffer readBuffer) {
        this.dataLog = dataLog;
        this.readableByteChannel = ((DataLog)dataLog).readableByteChannel;
        this.readBuffer = this.createBuffer(dataLog, readBuffer);
    }

    protected ByteBuffer createBuffer(D dataLog, ByteBuffer readBuffer) {
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readBuffer(ByteBuffer byteBuffer) throws IOException {
        try {
            int result;
            byteBuffer.clear();
            D d = this.dataLog;
            synchronized (d) {
                this.readBufferPosition = ((DataLog)this.dataLog).fileChannelPosition;
                result = this.readableByteChannel.read(byteBuffer);
                ((DataLog)this.dataLog).fileChannelPosition += (long)result;
            }
            byteBuffer.flip();
            if (result == -1) {
                ((DataLog)this.dataLog).readerReachEOS(this);
            }
            return result;
        }
        catch (IOException ex) {
            ((DataLog)this.dataLog).readerReachEOS(this);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        ((DataLog)this.dataLog).readerClosed(this);
    }

    public D getDataLog() {
        return this.dataLog;
    }
}

