/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.server.service;

import jakarta.jws.WebService;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQServer;
import ru.bitel.bgbilling.kernel.event.publish.common.service.MQServerService;
import ru.bitel.bgbilling.kernel.event.publish.server.bean.MQServerDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.event.publish.common.service.MQServerService")
public class MQServerServiceImpl
extends AbstractService
implements MQServerService {
    private MQServerDao mqServerDao;

    @Override
    public SearchResult<MQServer> searchMQServerList(Page page) throws BGException {
        return this.tryReturn(() -> this.getMQServerDao().searchMQServerList(page));
    }

    @Override
    public MQServer getMQServer(int mqServerId) throws BGException {
        return this.tryReturn(() -> (MQServer)this.getMQServerDao().get(mqServerId));
    }

    @Override
    public MQServer updateMQServer(MQServer mqServer) throws BGException {
        return this.tryReturn(() -> {
            this.getMQServerDao().update(mqServer);
            return mqServer;
        });
    }

    @Override
    public boolean deleteMQServer(int mqServerId) throws BGException {
        return this.tryReturn(() -> this.getMQServerDao().delete(mqServerId) > 0);
    }

    private MQServerDao getMQServerDao() {
        this.mqServerDao = new MQServerDao(this.getConnection());
        return Optional.ofNullable(this.mqServerDao).orElse(this.mqServerDao);
    }
}

