/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionData;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionExpressionData;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.PermissionKitItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UnregRequestRecord;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.server.UserActionRecorderCache;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.ActionExpressionDataDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSActionGroupDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSActionUtils;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.PermissionKitDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.RequestRecordLogDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.RoleDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserRecordLogDao;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.common.event.PermissionKitUpdateEvent;
import ru.bitel.bgbilling.kernel.module.common.event.RoleUpdateEvent;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService")
public class RoleServiceImpl
extends AbstractService
implements RoleService {
    private Connection connection;
    private RoleDao roleDao;
    private BGSActionGroupDao actionGroupDao;
    private PermissionKitDao permissionKitDao;
    private RequestRecordLogDao requestRecordLogDao;
    private ActionExpressionDataDao actionExpressionDataDao;

    @PostConstruct
    public void init() {
        this.connection = this.getConnection();
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
    }

    private RoleDao getRoleDao() {
        this.roleDao = new RoleDao(this.connection);
        return Optional.ofNullable(this.roleDao).orElse(this.roleDao);
    }

    private BGSActionGroupDao getBGSActionGroupDao() {
        this.actionGroupDao = new BGSActionGroupDao(this.connection);
        return Optional.ofNullable(this.actionGroupDao).orElse(this.actionGroupDao);
    }

    private PermissionKitDao getPermissionKitDao() {
        this.permissionKitDao = new PermissionKitDao(this.connection);
        return Optional.ofNullable(this.permissionKitDao).orElse(this.permissionKitDao);
    }

    private RequestRecordLogDao getRequestRecordLogDao() {
        this.requestRecordLogDao = new RequestRecordLogDao(this.connection);
        return Optional.ofNullable(this.requestRecordLogDao).orElse(this.requestRecordLogDao);
    }

    private ActionExpressionDataDao getActionExpressionDataDao() {
        this.actionExpressionDataDao = new ActionExpressionDataDao(this.connection);
        return Optional.ofNullable(this.actionExpressionDataDao).orElse(this.actionExpressionDataDao);
    }

    @Override
    public List<Role> getRoles() throws BGException {
        return (List)this.tryReturn(() -> this.getRoleDao().list(null, null, new Object[0]));
    }

    @Override
    public List<RoleItem> getRoleItems(boolean initChilds, boolean sortByTitle) throws BGException {
        return (List)this.tryReturn(() -> {
            List<RoleItem> roleItems = this.getRoleDao().roleItemList(initChilds);
            if (sortByTitle) {
                Collections.sort(roleItems, Comparator.comparing(IdTitle::getTitle, String::compareTo));
            }
            return roleItems;
        });
    }

    @Override
    public Role getByRoleId(int roleId) throws BGException {
        return (Role)((Object)this.tryReturn(() -> (Role)this.getRoleDao().get(roleId)));
    }

    @Override
    public void updateRole(Role role) throws BGException {
        this.tryCall(() -> {
            this.getRoleDao().update((Object)role);
            EventProcessor.getInstance().request(new RoleUpdateEvent(role.getId(), this.userId));
        });
    }

    @Override
    public void deleteRole(Role role) throws BGException {
        this.tryCall(() -> {
            if (role == null) {
                return;
            }
            this.deleteRoleById(role.getId());
        });
    }

    @Override
    public void deleteRoleById(int roleId) throws BGException {
        this.tryCall(() -> {
            ArrayList users = new ArrayList();
            UserMap.getMap().values().forEach(user -> {
                if (user.getRoleId() == roleId) {
                    users.add(user.getTitle());
                }
            });
            if (!users.isEmpty()) {
                Object errorMessage = "\u0420\u043e\u043b\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439: ";
                errorMessage = (String)errorMessage + (users.size() > 0 ? (String)users.get(0) : "");
                errorMessage = (String)errorMessage + (String)(users.size() > 1 ? "; " + (String)users.get(1) : "");
                errorMessage = (String)errorMessage + (String)(users.size() > 2 ? "; ( \u0435\u0449\u0435 +" + (users.size() - 2) : "");
                throw new BGMessageException((String)errorMessage);
            }
            this.getRoleDao().delete(roleId);
            EventProcessor.getInstance().request(new RoleUpdateEvent(roleId, this.userId));
        });
    }

    @Override
    public List<BGSActionGroup> getBGSActionGroups() throws BGException {
        return (List)this.tryReturn(() -> this.getBGSActionGroupDao().getList());
    }

    @Override
    public void updateBGSActionGroup(BGSActionGroup group) throws BGException {
        this.tryCall(() -> {
            this.getBGSActionGroupDao().update((Object)group);
            EventProcessor.getInstance().request(new RoleUpdateEvent(-1, this.userId));
        });
    }

    @Override
    public void deleteBGSActionGroup(BGSActionGroup group) throws BGException {
        this.tryCall(() -> this.getBGSActionGroupDao().delete(group.getId()));
    }

    @Override
    public List<IdTitle> getKitItems() throws BGException {
        return (List)this.tryReturn(() -> this.getPermissionKitDao().getKitItems());
    }

    @Override
    public List<PermissionKitItem> getPermissionKitItems() throws BGException {
        return (List)this.tryReturn(() -> this.getPermissionKitDao().getPermissionKitItems());
    }

    @Override
    public PermissionKit getByKitId(int kitId) throws BGException {
        return (PermissionKit)((Object)this.tryReturn(() -> (PermissionKit)this.getPermissionKitDao().get(kitId)));
    }

    @Override
    public int updatePermissionKit(PermissionKit kit) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.getPermissionKitDao().update((Object)kit);
            EventProcessor.getInstance().request(new PermissionKitUpdateEvent(kit.getId(), this.getRolesIdsContainsKit(kit.getId()), this.userId, PermissionKitUpdateEvent.EventType.UPDATE));
            return kit.getId();
        });
    }

    @Override
    public void deletePermissionKit(int permissionKitId) throws BGException {
        this.tryCall(() -> {
            List<Role> rolesWithKit = this.getRolesContainsKit(permissionKitId);
            for (Role role : rolesWithKit) {
                role.getPermissionKits().removeIf(kit -> kit.getId() == permissionKitId);
                this.updateRole(role);
            }
            this.getPermissionKitDao().delete(permissionKitId);
            List<Integer> rolesWithKitIds = rolesWithKit.stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
            PermissionKitUpdateEvent event = new PermissionKitUpdateEvent(permissionKitId, rolesWithKitIds, this.userId, PermissionKitUpdateEvent.EventType.DELETE);
            EventProcessor.getInstance().request(event);
        });
    }

    @Override
    public int checkRoleContainsKit(int permissionKitId) throws BGException {
        return this.getRolesContainsKit(permissionKitId).size();
    }

    private List<Integer> getRolesIdsContainsKit(int permissionKitId) throws BGException {
        return this.getRolesContainsKit(permissionKitId).stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
    }

    private List<Role> getRolesContainsKit(int permissionKitId) throws BGException {
        return this.getRoles().stream().filter(r -> r.getPermissionKits() != null && r.getPermissionKits().stream().filter(kit -> kit.getId() == permissionKitId).collect(Collectors.toList()).size() > 0).collect(Collectors.toList());
    }

    @Override
    public SearchResult<UnregRequestRecord> searchUnregRequestRecordList(Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            HashMap componentMap = new HashMap();
            ModuleService moduleService = this.context.getService(ModuleService.class, 0);
            moduleService.moduleList().forEach(a -> componentMap.put(String.valueOf(a.getId()), a.getName()));
            moduleService.installedPluginList().forEach(a -> componentMap.put("p" + a.getId(), a.getGuiTitle()));
            SearchResult searchResult = new SearchResult(page);
            new UserRecordLogDao(this.getConnection()).searchUnregRequestRecordList((SearchResult<UnregRequestRecord>)searchResult);
            searchResult.getList().forEach(a -> {
                if ("0".equals(a.getModuleId())) {
                    a.setModuleName("kernel");
                } else {
                    a.setModuleName(componentMap.getOrDefault(a.getModuleId(), "?"));
                }
            });
            return searchResult;
        });
    }

    @Override
    public void clearUnregRequestRecordList(List<String> recordIds) throws BGException {
        this.tryCall(() -> {
            UserRecordLogDao userRecordLogDao = new UserRecordLogDao(this.getConnection());
            if (recordIds == null || recordIds.isEmpty()) {
                userRecordLogDao.clearUnregRequestRecordList();
            } else {
                userRecordLogDao.clearUnregRequestActionRecord(recordIds.stream().filter(a -> a.startsWith("action_")).toList());
                userRecordLogDao.clearUnregRequestServiceRecord(recordIds.stream().filter(a -> a.startsWith("service_")).toList());
            }
        });
    }

    @Override
    public void recheckUnregRequestRecordList() throws BGException {
        this.tryCall(() -> {
            UserRecordLogDao userRecordLogDao = new UserRecordLogDao(this.getConnection());
            SearchResult searchResult = new SearchResult();
            userRecordLogDao.searchUnregRequestRecordList((SearchResult<UnregRequestRecord>)searchResult);
            searchResult.getList().forEach(a -> {
                ModuleAction moduleAction = null;
                try {
                    moduleAction = FindAction.find(new String[]{a.getModuleId()}, a.getService(), a.getOperation(), null);
                    if (moduleAction != null) {
                        userRecordLogDao.deleteUnregRequestRecord((UnregRequestRecord)a);
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            });
        });
    }

    @Override
    public SearchResult<RequestRecordLog> searchRequestRecordLogList() throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult();
            this.getRequestRecordLogDao().searchRequestRecordLogList((SearchResult<RequestRecordLog>)searchResult);
            for (RequestRecordLog log : searchResult.getList()) {
                RequestRecordLog cacheLog = UserActionRecorderCache.getInstance().getInProgress().get(log.getUserId());
                if (cacheLog == null) {
                    if (log.getEndRecordingTime() != null) continue;
                    UserActionRecorderCache.getInstance().getInProgress().put(this.userId, log);
                    continue;
                }
                if (cacheLog.getId() != log.getId()) continue;
                log.setActions(cacheLog.getActions());
            }
            return searchResult;
        });
    }

    @Override
    public void deleteRequestRecordLog(RequestRecordLog log) throws BGException {
        this.tryCall(() -> {
            UserActionRecorderCache.getInstance().getInProgress().remove(log.getUserId());
            this.getRequestRecordLogDao().delete(log.getId());
        });
    }

    @Override
    public void startRecordingActions(int userId, String title) throws BGException {
        this.tryCall(() -> {
            RequestRecordLog userActionsRecording = UserActionRecorderCache.getInstance().getInProgress().get(userId);
            if (userActionsRecording != null) {
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ID=" + userId + " \u0443\u0436\u0435 \u0432\u0435\u0434\u0451\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439!");
            }
            userActionsRecording = new RequestRecordLog();
            userActionsRecording.setTitle(title);
            userActionsRecording.setStartRecordingTime(new Date());
            userActionsRecording.setUserId(userId);
            this.getRequestRecordLogDao().update((Object)userActionsRecording);
            UserActionRecorderCache.getInstance().getInProgress().put(userId, userActionsRecording);
        });
    }

    @Override
    public RequestRecordLog stopRecordingActions(int user) throws BGException {
        return (RequestRecordLog)((Object)this.tryReturn(() -> {
            UserActionRecorderCache recorderCache = UserActionRecorderCache.getInstance();
            RequestRecordLog userActionsRecording = recorderCache.getInProgress().get(user);
            if (userActionsRecording == null) {
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ID=" + user + " \u043d\u0435 \u0432\u0435\u0434\u0451\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
            }
            RequestRecordLog stoppedRecord = recorderCache.stopRecording(user);
            this.getRequestRecordLogDao().update((Object)stoppedRecord);
            return stoppedRecord;
        }));
    }

    @Override
    public void updateRequestLog(RequestRecordLog requestRecordLog) throws BGException {
        this.tryCall(() -> {
            RequestRecordLog fromCache = UserActionRecorderCache.getInstance().getInProgress().get(requestRecordLog.getUserId());
            if (fromCache != null) {
                fromCache.setActions(requestRecordLog.getActions());
            }
            this.getRequestRecordLogDao().update((Object)requestRecordLog);
        });
    }

    @Override
    public List<ActionExpressionData> actionExpressionDataList(String componentId, List<Integer> actionsIds) throws BGException {
        return (List)this.tryReturn(() -> this.getActionExpressionDataDao().list(componentId, actionsIds));
    }

    @Override
    public ActionExpressionData actionExpressionDataGet(int id) throws BGException {
        return (ActionExpressionData)((Object)this.tryReturn(() -> (ActionExpressionData)this.getActionExpressionDataDao().get(id)));
    }

    @Override
    public void actionExpressionDataUpdate(ActionExpressionData actionExpressionData) throws BGException {
        this.tryCall(() -> {
            this.getActionExpressionDataDao().update((Object)actionExpressionData);
            EventProcessor.getInstance().request(new PermissionKitUpdateEvent(0, PermissionKitUpdateEvent.EventType.UPDATE));
        });
    }

    @Override
    public void actionExpressionDataDelete(int id) throws BGException {
        this.tryCall(() -> {
            this.getActionExpressionDataDao().delete(id);
            EventProcessor.getInstance().request(new PermissionKitUpdateEvent(0, PermissionKitUpdateEvent.EventType.DELETE));
        });
    }

    @Override
    public ActionData actionDataRoot(String componentName) throws BGException {
        return (ActionData)this.tryReturn(() -> BGSActionUtils.getActionDataRoot(componentName));
    }
}

