/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.util.RangedIntegerSet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceNet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscriptionReal;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceModifiedEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceSubscriptionEvent;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionRealDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.VlanCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.VlanResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.VlanResourceSubscriptionDao;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.resource.common.service.ResourceService")
public class ResourceServiceImpl
extends AbstractService
implements ResourceService {
    private IpCategoryDao ipCategoryDao = null;
    private IpResourceDao ipResourceDao = null;
    private VlanResourceDao vlanResourceDao = null;
    private VlanCategoryDao vlanCategoryDao = null;
    private IpResourceSubscriptionDao ipResourceSubscriptionDao = null;
    private VlanResourceSubscriptionDao vlanResourceSubscriptionDao = null;
    private IpResourceSubscriptionRealDao ipResourceSubscriptionRealDao = null;

    @PostConstruct
    protected void init() {
        this.vlanResourceSubscriptionDao = new VlanResourceSubscriptionDao(this.getConnection(), this.moduleId);
        this.ipResourceSubscriptionDao = new IpResourceSubscriptionDao(this.getConnection(), this.moduleId);
        this.ipResourceSubscriptionRealDao = new IpResourceSubscriptionRealDao(this.getConnection(), this.moduleId);
    }

    private VlanResourceDao getVlanResourceDao() {
        this.vlanResourceDao = new VlanResourceDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.vlanResourceDao).orElse(this.vlanResourceDao);
    }

    private IpCategoryDao getIpCategoryDao() {
        this.ipCategoryDao = new IpCategoryDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.ipCategoryDao).orElse(this.ipCategoryDao);
    }

    private IpResourceDao getIpResourceDao() {
        this.ipResourceDao = new IpResourceDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.ipResourceDao).orElse(this.ipResourceDao);
    }

    private VlanCategoryDao getVlanCategoryDao() {
        this.vlanCategoryDao = new VlanCategoryDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.vlanCategoryDao).orElse(this.vlanCategoryDao);
    }

    public List<VlanResource> vlanResourceList(int categoryId) throws BGException {
        return (List)this.tryReturn(() -> categoryId > 0 ? this.getVlanResourceDao().list(categoryId) : this.getVlanResourceDao().list());
    }

    public VlanResource vlanResourceGet(int id) throws BGException {
        return (VlanResource)this.tryReturn(() -> (VlanResource)this.getVlanResourceDao().get(id));
    }

    public void vlanResourceDelete(int id) throws BGException {
        this.tryCall(() -> {
            List<VlanResourceSubscription> list = this.vlanResourceSubscriptionDao.list(id, null, null);
            if (list.size() > 0) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
            }
            this.getVlanResourceDao().delete(id);
        });
    }

    public int vlanResourceUpdate(VlanResource resource) throws BGException {
        return (Integer)this.tryReturn(() -> {
            List<VlanResourceSubscription> subList;
            VlanResource oldRes;
            List<VlanResource> list = this.getVlanResourceDao().list(resource.getCategoryId());
            for (VlanResource r : list) {
                if (r.getId() == resource.getId() || r.getVlanFrom() > resource.getVlanTo() || r.getVlanTo() < resource.getVlanFrom() || r.getDateFrom() != null && resource.getDateTo() != null && r.getDateFrom().compareTo(resource.getDateTo()) > 0 || r.getDateTo() != null && resource.getDateFrom() != null && r.getDateTo().compareTo(resource.getDateFrom()) < 0) continue;
                throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0440\u0443\u0433\u0438\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438!");
            }
            if (resource.getId() > 0 && ((oldRes = (VlanResource)this.getVlanResourceDao().get(resource.getId())).getDateFrom() == null ^ resource.getDateFrom() == null || oldRes.getDateFrom() != null && oldRes.getDateFrom().compareTo(resource.getDateFrom()) != 0 || oldRes.getDateTo() == null ^ resource.getDateTo() == null || oldRes.getDateTo() != null && oldRes.getDateTo().compareTo(resource.getDateTo()) != 0 || oldRes.getVlanFrom() != resource.getVlanFrom() || oldRes.getVlanTo() != resource.getVlanTo()) && (subList = this.vlanResourceSubscriptionDao.list(resource.getId(), null, null)).size() > 0) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
            }
            this.getVlanResourceDao().update(resource);
            return resource.getId();
        });
    }

    public Integer freeVlan(Set<Integer> vlanResourceCategoryIds, Date dateFrom, Date dateTo) throws BGException {
        return (Integer)this.tryReturn(() -> {
            Integer vlan = null;
            boolean reverse = this.getModuleSetup().getInt("vlan.resource.reverse", 0) > 0;
            for (VlanResource resource : this.getVlanResourceDao().list(vlanResourceCategoryIds, dateFrom, dateTo)) {
                Set<Integer> subscribed = this.vlanResourceSubscriptionDao.subscribedVlans(resource.getId(), dateFrom, dateTo);
                RangedIntegerSet intSet = new RangedIntegerSet(new int[]{resource.getVlanFrom(), resource.getVlanTo()});
                vlan = reverse ? intSet.nextReverse(intSet.size() - 1, subscribed) : intSet.next(0, subscribed);
                if (vlan == null) continue;
                break;
            }
            if (vlan == null) {
                throw new BGMessageException("\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 VLAN \u0432 \u0440\u0435\u0441\u0443\u0440\u0441\u0435 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434.");
            }
            return vlan;
        });
    }

    @Deprecated
    public Integer nextFreeVlan(int vlanResourceCategoryId, int deviceId, Date dateFrom, Date dateTo) throws BGException {
        return this.freeVlan(Collections.singleton(vlanResourceCategoryId), dateFrom, dateTo);
    }

    public boolean vlanResourceSubscribe(int vlan, short subscriberType, int subscriberId, String subscriberTitle, Date dateFrom, Date dateTo, Set<Integer> vlanResourceCategoryIds, boolean isVlanPersonal) throws BGException {
        return (Boolean)this.tryReturn(() -> {
            VlanResourceSubscription subcripton = new VlanResourceSubscription();
            this.vlanResourceUnsubscribe(subscriberType, subscriberId);
            List<VlanResource> sources = this.getVlanResourceDao().list(vlanResourceCategoryIds, dateFrom, dateTo);
            int resourceId = -1;
            for (VlanResource resource : sources) {
                if (resource.getVlanFrom() > vlan || vlan > resource.getVlanTo()) continue;
                if (isVlanPersonal) {
                    List<VlanResourceSubscription> list = this.vlanResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo);
                    for (VlanResourceSubscription sub : list) {
                        if (sub.getVlan() != vlan) continue;
                        throw new BGMessageException("\u042d\u0442\u043e\u0442 VLAN \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442.");
                    }
                }
                if (resourceId != -1) continue;
                resourceId = resource.getId();
            }
            if (resourceId == -1) {
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 VLAN.");
            }
            subcripton.setSubscriberType(subscriberType);
            subcripton.setSubscriberId(subscriberId);
            subcripton.setSubscriberTitle(subscriberTitle);
            subcripton.setVlan(vlan);
            subcripton.setVlanResourseId(resourceId);
            subcripton.setDateFrom(dateFrom);
            subcripton.setDateTo(dateTo);
            this.vlanResourceSubscriptionDao.update(subcripton);
            return true;
        });
    }

    @Deprecated
    public void vlanResourceUnsubscribe(int subscriberId) throws BGException {
        this.vlanResourceUnsubscribe((short)1, subscriberId);
    }

    public void vlanResourceUnsubscribe(short subscriberType, int subscriberId) throws BGException {
        this.tryCall(() -> this.vlanResourceSubscriptionDao.deleteBySubscriberId(subscriberType, subscriberId));
    }

    public List<VlanResourceSubscription> vlanSubscriptionList1(int vlanResourceId, Date dateFrom, Date dateTo) throws BGException {
        return this.vlanResourceSubscriptionDao.list(vlanResourceId, dateFrom, dateTo);
    }

    public Result<VlanResourceSubscription> vlanSubscriptionList(int vlanResourceId, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.vlanResourceSubscriptionDao.list(vlanResourceId, dateFrom, dateTo, page);
    }

    public IpCategory ipCategoryRoot() throws BGException {
        return (IpCategory)this.tryReturn(() -> this.getIpCategoryDao().root());
    }

    public List<IpCategory> ipCategoryList() throws BGException {
        return (List)this.tryReturn(() -> this.getIpCategoryDao().list());
    }

    public int ipCategoryUpdate(IpCategory category) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.getIpCategoryDao().update(category);
            return category.getId();
        });
    }

    public void ipCategoryDelete(int id) throws BGException {
        this.tryCall(() -> {
            if (this.getIpResourceDao().list(id).size() > 0) {
                throw new BGMessageException("\u0412 \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u0435\u0441\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0432\u043d\u0430\u0447\u0430\u043b\u0435 \u0438\u0445");
            }
            this.getIpCategoryDao().delete(id);
        });
    }

    public List<IpResource> ipResourceList(Collection<Integer> categoryIds) throws BGException {
        return (List)this.tryReturn(() -> {
            if (categoryIds != null && categoryIds.size() > 0) {
                ArrayList<IpResource> result = new ArrayList<IpResource>();
                for (Integer categoryId : categoryIds) {
                    result.addAll(this.getIpResourceDao().list(categoryId));
                }
                return result;
            }
            return this.getIpResourceDao().list();
        });
    }

    public void ipResourceDelete(int id, boolean skipSubscriptionCheck) throws BGException {
        this.tryCall(() -> {
            List subList;
            if (!skipSubscriptionCheck && (subList = this.ipResourceSubscriptionDao.list(id, null, null, new Page(1, 1)).getList()).size() > 0) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438!");
            }
            IpResource oldIpResource = (IpResource)this.getIpResourceDao().getAndDelete(id);
            this.context.publishAfterCommit(new IpResourceModifiedEvent(this.moduleId, this.userId, oldIpResource.getCategoryId(), oldIpResource.getId()));
        });
    }

    public int ipResourceUpdate(IpResource resource, boolean skipSubscriptionCheck) throws BGException {
        return (Integer)this.tryReturn(() -> {
            List<IpResourceSubscription> subList;
            IpResource oldRes;
            HashSet<Integer> categoryIds = new HashSet<Integer>();
            categoryIds.add(resource.getCategoryId());
            if (IpAddress.compare((byte[])resource.getAddressFrom(), (byte[])resource.getAddressTo()) > 0) {
                throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d IP-\u0430\u0434\u0440\u0435\u0441\u043e\u0432");
            }
            if (TimeUtils.dateBefore((Date)resource.getDateTo(), (Date)resource.getDateFrom())) {
                throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0434\u0430\u0442");
            }
            List<IpResource> list = this.getIpResourceDao().list(categoryIds, null, resource.getDateFrom(), resource.getDateTo(), null);
            for (IpResource res : list) {
                if (res.getId() == resource.getId() || IpAddress.compare((byte[])res.getAddressFrom(), (byte[])resource.getAddressTo()) > 0 || IpAddress.compare((byte[])res.getAddressTo(), (byte[])resource.getAddressFrom()) < 0) continue;
                throw new BGMessageException("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438 \u0432 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438.");
            }
            if (resource.getId() > 0 && !skipSubscriptionCheck && ((oldRes = (IpResource)this.getIpResourceDao().get(resource.getId())).getDateFrom() == null ^ resource.getDateFrom() == null || oldRes.getDateFrom() != null && oldRes.getDateFrom().compareTo(resource.getDateFrom()) != 0 || oldRes.getDateTo() == null ^ resource.getDateTo() == null || oldRes.getDateTo() != null && oldRes.getDateTo().compareTo(resource.getDateTo()) != 0 || IpAddress.compare((byte[])oldRes.getAddressFrom(), (byte[])resource.getAddressFrom()) != 0 || IpAddress.compare((byte[])oldRes.getAddressTo(), (byte[])resource.getAddressTo()) != 0) && (subList = this.ipResourceSubscriptionDao.list(resource.getId(), null, null)).size() > 0) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438.");
            }
            if (Utils.notBlankString((String)resource.getDns())) {
                String[] addresses;
                for (String address : addresses = resource.getDns().trim().split("\\s*,\\s*")) {
                    try {
                        InetAddress.getByName(address);
                    }
                    catch (UnknownHostException e) {
                        throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 IP-\u0430\u0434\u0440\u0435\u0441\u0430 DNS: " + address);
                    }
                }
            }
            if (Utils.isBlankString((String)resource.getDns())) {
                resource.setDns("");
            }
            this.getIpResourceDao().update(resource);
            this.context.publishAfterCommit(new IpResourceModifiedEvent(this.moduleId, this.userId, resource.getCategoryId(), resource.getId()));
            return resource.getId();
        });
    }

    public List<IpResourceNet> freeIpResourceNetList(Collection<Integer> ipResourceCategoryIds, Collection<Integer> ipResourceIds, Date dateFrom, Date dateTo, int mask, int max, String filter) throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList result = new ArrayList();
            for (IpResource resource : this.getIpResourceDao().list(ipResourceCategoryIds, ipResourceIds, dateFrom, dateTo, false)) {
                List<IpResourceSubscription> subscriptionList = this.ipResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo);
                IpResourceNet.newIpResourceNetList((IpResource)resource, subscriptionList, (String)filter, (int)mask, (int)(max - result.size()), result);
                if (result.size() < max) continue;
                break;
            }
            return result;
        });
    }

    public List<IpResourceRange> freeIpResourceRangeList(Collection<Integer> ipResourceCategoryIds, Collection<Integer> ipResourceIds, Date dateFrom, Date dateTo, int range, int max, String filter) throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList result = new ArrayList();
            for (IpResource resource : this.getIpResourceDao().list(ipResourceCategoryIds, ipResourceIds, dateFrom, dateTo, false)) {
                List<IpResourceSubscription> subscriptionList = this.ipResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo);
                if (resource.isReserveStart()) {
                    subscriptionList.add(0, new IpResourceSubscription().setIpResourseId(resource.getId()).setAddressFrom(resource.getAddressFrom()).setAddressTo(resource.getAddressFrom()));
                }
                if (resource.isReserveEnd()) {
                    subscriptionList.add(new IpResourceSubscription().setIpResourseId(resource.getId()).setAddressFrom(resource.getAddressTo()).setAddressTo(resource.getAddressTo()));
                }
                IpResourceRange.newIpRangeList((IpResource)resource, subscriptionList, (String)filter, (int)range, (int)(max - result.size()), result);
                if (result.size() < max) continue;
                break;
            }
            return result;
        });
    }

    private void ipResourceUnsubscribeReal(int subscriberId, byte[] addressFrom, byte[] addressTo) throws BGException {
        this.tryCall(() -> {
            GregorianCalendar calendar = new GregorianCalendar();
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            Date today = calendar.getTime();
            ((Calendar)calendar).add(5, -1);
            Date yesterday = calendar.getTime();
            IpResourceSubscriptionReal oldSubscription = this.ipResourceSubscriptionRealDao.findFromDate(subscriberId, addressFrom, addressTo, today);
            if (oldSubscription == null) {
                this.getLogger().warn("Subcribe was not found for unsuscribing");
                return;
            }
            if (oldSubscription.getDateFrom() != null && TimeUtils.dateBefore((Date)today, (Date)oldSubscription.getDateFrom())) {
                this.ipResourceSubscriptionRealDao.delete(oldSubscription.getId());
                return;
            }
            if (oldSubscription.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)today, (Date)oldSubscription.getDateTo())) {
                oldSubscription.setDateTo(yesterday);
            }
            if (TimeUtils.dateBefore((Date)oldSubscription.getDateTo(), (Date)oldSubscription.getDateFrom())) {
                this.ipResourceSubscriptionRealDao.delete(oldSubscription.getId());
            } else {
                this.ipResourceSubscriptionRealDao.update(oldSubscription);
            }
        });
    }

    public void ipResourceUnsubscribe(int subscriberId, int ipResourceSubscriptionId, byte[] addressFrom, byte[] addressTo) throws BGException {
        this.tryCall(() -> {
            IpResourceSubscription oldSubscription;
            IpResourceSubscription ipResourceSubscription = oldSubscription = ipResourceSubscriptionId > 0 ? (IpResourceSubscription)this.ipResourceSubscriptionDao.get(ipResourceSubscriptionId) : this.ipResourceSubscriptionDao.findSubscribed(subscriberId);
            if (oldSubscription == null) {
                this.getLogger().warn("Subcribe was not found for unsuscribing");
                return;
            }
            this.ipResourceSubscriptionDao.delete(ipResourceSubscriptionId);
            this.ipResourceUnsubscribeReal(subscriberId, addressFrom, addressTo);
            this.context.publishAfterCommit(new IpResourceSubscriptionEvent(2, this.moduleId, -1, subscriberId, null, oldSubscription.getIpResourseId(), oldSubscription.getId(), oldSubscription.getAddressFrom(), oldSubscription.getAddressTo(), null, oldSubscription.getDateTo(), false));
        });
    }

    private IpResourceSubscriptionReal ipResourceSubscribeReal(int subscriberId, String subscriberTitle, byte[] addressFrom, byte[] addressTo, Date dateFrom, Date dateTo) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        Date today = calendar.getTime();
        if (TimeUtils.dateBefore((Date)dateTo, (Date)today)) {
            return null;
        }
        IpResourceSubscriptionReal subscription = new IpResourceSubscriptionReal().setSubscriberId(subscriberId).setSubscriberTitle(subscriberTitle).setDateTo(dateTo).setAddressFrom(addressFrom).setAddressTo(addressTo != null ? addressTo : addressFrom).setDateFrom(TimeUtils.dateBefore((Date)today, (Date)dateFrom) ? dateFrom : today);
        try {
            this.ipResourceSubscriptionRealDao.update(subscription);
            return subscription;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public IpResourceSubscription ipResourceSubscribe(int subscriberId, String subscriberTitle, Collection<Integer> ipResourceCategoryIds, int ipResourceId, byte[] addressFrom, byte[] addressTo, Date dateFrom, Date dateTo) throws BGException {
        Object[] resourceRef;
        if (addressTo == null) {
            addressTo = addressFrom;
        }
        GregorianCalendar utilCalendar = new GregorianCalendar();
        if (dateFrom != null) {
            utilCalendar.setTime(dateFrom);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
            dateFrom = utilCalendar.getTime();
        }
        if (dateTo != null) {
            utilCalendar.setTime(dateTo);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
            ((Calendar)utilCalendar).add(5, 1);
            ((Calendar)utilCalendar).add(14, -1);
            dateTo = utilCalendar.getTime();
        }
        IpResourceSubscription subscription = new IpResourceSubscription().setSubscriberId(subscriberId).setSubscriberTitle(subscriberTitle).setDateFrom(dateFrom).setDateTo(dateTo).setAddressFrom(addressFrom).setAddressTo(addressTo);
        try {
            resourceRef = this.ipResourceSubscriptionDao.findFree(ipResourceCategoryIds, ipResourceId, addressFrom, addressTo, dateFrom, dateTo, subscriberId);
        }
        catch (Exception e) {
            throw new BGMessageException(e.getMessage());
        }
        if (resourceRef == null) {
            throw new BGMessageException("\u041f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 ip \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        IpResource resource = (IpResource)resourceRef[0];
        subscription.setIpResourseId(resource.getId());
        try {
            this.ipResourceSubscriptionDao.update(subscription);
            this.ipResourceSubscribeReal(subscriberId, subscriberTitle, addressFrom, addressTo, dateFrom, dateTo);
            this.context.publishAfterCommit(new IpResourceSubscriptionEvent(1, this.moduleId, -1, subscriberId, subscription.getSubscriberTitle(), subscription.getIpResourseId(), subscription.getId(), subscription.getAddressFrom(), subscription.getAddressTo(), subscription.getDateFrom(), subscription.getDateTo(), false));
            return subscription;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected boolean dateEqual(Date date1, Date date2) {
        return date1 == null && date2 == null || date1 != null && date2 != null && TimeUtils.dateEqual((Date)date1, (Date)date2);
    }

    public VlanCategory vlanCategoryRoot() throws BGException {
        return (VlanCategory)this.tryReturn(() -> this.getVlanCategoryDao().root());
    }

    public int vlanCategoryUpdate(VlanCategory category) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.getVlanCategoryDao().update(category);
            return category.getId();
        });
    }

    public void vlanCategoryDelete(int id) throws BGException {
        this.tryCall(() -> {
            if (this.getVlanResourceDao().list(id).size() > 0) {
                throw new BGMessageException(" \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u0443 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e, \u0442\u0430\u043a \u043a\u0430\u043a \u0432 \u043d\u0435\u0439 \u0435\u0441\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b");
            }
            this.getVlanCategoryDao().delete(id);
        });
    }

    public Result<IpResourceSubscription> ipSubscriptionList(int ipResourceId, Date dateFrom, Date dateTo, Page page) throws BGException {
        return (Result)this.tryReturn(() -> this.ipResourceSubscriptionDao.list(ipResourceId, dateFrom, dateTo, page));
    }

    protected List<VlanResource> getVlanResources(Set<Integer> vlanResourceCategoryIds) throws BGException {
        return (List)this.tryReturn(() -> this.getVlanResourceDao().list(vlanResourceCategoryIds));
    }

    public IpResource ipResourceGet(int id) throws BGException {
        return (IpResource)this.tryReturn(() -> (IpResource)this.getIpResourceDao().get(id));
    }
}

