/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rurupay.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.base.server.util.SequentialIdManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.rurupay.common.bean.RuRuPayCancelReason;
import ru.bitel.bgbilling.modules.rurupay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rurupay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.rurupay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

@WebServlet(name="RuRuPayExecutor", urlPatterns={"/rurupayexecuter/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static TimeZone TZ_RURU = TimeZone.getTimeZone("Europe/Moscow");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int mid;
        String pathInfo = request.getPathInfo();
        int n = mid = Utils.notBlankString((String)pathInfo) ? Utils.parseInt((String)pathInfo.replace("/", ""), (int)0) : 0;
        if (mid <= 0) {
            this.doReply(response, ReplyErrorCode.ERR_999, "parameter mid in url required", null, null);
            this.getLogger().error("return error reply: parameter mid in url required");
            return;
        }
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(mid));
        if (moduleSetup == null) {
            this.doReply(response, ReplyErrorCode.ERR_999, "error get module config for mid=" + mid, null, null);
            this.getLogger().error("return error reply: error get module config for mid=" + mid);
            return;
        }
        String secretword = moduleSetup.get("secretword");
        if (secretword == null) {
            this.doReply(response, ReplyErrorCode.ERR_999, "secretword in module config required", null, null);
            this.getLogger().error("return error reply: secretword in module config required");
            return;
        }
        Connection con = this.setup.getDBConnectionFromPool();
        try (ContractDao contractDao = new ContractDao(con, mid);){
            RuRuPayRequest payrequest = this.getRequest(request, secretword);
            Contract contract = null;
            if (payrequest.externalId != null) {
                try {
                    String[] p = payrequest.externalId.split("_");
                    contract = (Contract)contractDao.get(Integer.parseInt(p[0]));
                    contract.getId();
                }
                catch (Exception e) {
                    throw new ParseRequestException("error externalId (contract not found?) : '" + payrequest.externalId + "'", ReplyErrorCode.ERR_103);
                }
            } else {
                contract = contractDao.getByTitle(payrequest.account);
                if (contract == null) {
                    throw new ParseRequestException("error account (contract not found?) : '" + payrequest.account + "'", ReplyErrorCode.ERR_101);
                }
                payrequest.externalId = ModuleExecutor.generateOrder(this.setup, contract.getId());
            }
            ResponseBody responseBody = new ResponseBody();
            TransactionManager paymentDao = new TransactionManager(con, mid);
            switch (payrequest.action.ordinal()) {
                case 0: {
                    Transaction payment = new Transaction().setContractId(contract.getId()).setTransactionDate(payrequest.date).setSum(new BigDecimal(payrequest.amount_kop).divide(new BigDecimal(100))).setOrder(payrequest.externalId).setStatus(TransactionStatus.NEW.getCode());
                    paymentDao.updateLogEntry(payment);
                    responseBody.amount_kop = payrequest.amount_kop;
                    responseBody.date = payrequest.date;
                    responseBody.externalId = payrequest.externalId;
                    responseBody.info = null;
                    responseBody.id = payrequest.id;
                    break;
                }
                case 2: {
                    Transaction payment = paymentDao.getByOrder(payrequest.externalId);
                    if (payment == null) {
                        throw new ParseRequestException("not found order with externalId (not coming init?) : '" + payrequest.externalId + "'", ReplyErrorCode.ERR_400);
                    }
                    payment.setTransactionDate(payrequest.date);
                    payment.setSum(new BigDecimal(payrequest.amount_kop).divide(new BigDecimal(100)));
                    payment.setStatus(TransactionStatus.OK.getCode());
                    paymentDao.updateLogEntry(payment);
                    paymentDao.carryOutPayment(payment, (Preferences)moduleSetup);
                    responseBody.amount_kop = payrequest.amount_kop;
                    responseBody.date = payrequest.date;
                    responseBody.externalId = payrequest.externalId;
                    responseBody.info = null;
                    responseBody.id = payrequest.id;
                    break;
                }
                case 1: {
                    Transaction payment = paymentDao.getByOrder(payrequest.externalId);
                    if (payment == null) {
                        throw new ParseRequestException("not found order with externalId (not coming init?) : '" + payrequest.externalId + "'", ReplyErrorCode.ERR_400);
                    }
                    payment.setStatus(TransactionStatus.FAIL.getCode());
                    payment.setCancelReason(payrequest.reason);
                    paymentDao.updateLogEntry(payment);
                    responseBody.date = new Date();
                    responseBody.externalId = payrequest.externalId;
                    responseBody.id = payrequest.id;
                }
            }
            this.doReply(response, ReplyErrorCode.ERR_0, null, responseBody, secretword);
        }
        catch (ParseRequestException e) {
            this.doReply(response, e.getErrorCode(), e.getMessage(), null, secretword);
            this.getLogger().error("return error reply: " + e.getMessage());
        }
        catch (Exception e) {
            this.getLogger().error("error do post", (Throwable)e);
            this.doReply(response, ReplyErrorCode.ERR_999, "internal error", null, secretword);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public void doReply(HttpServletResponse response, ReplyErrorCode ErrorCode, String ErrorDescription, ResponseBody responseBody, String secretword) throws IOException {
        String amount_kop = responseBody != null && responseBody.amount_kop != null ? String.valueOf(responseBody.amount_kop) : null;
        String date = responseBody != null && responseBody.date != null ? TimeUtils.format((Date)responseBody.date, (String)DATE_FORMAT, (TimeZone)TZ_RURU) : null;
        String externalId = responseBody != null ? responseBody.externalId : null;
        String info = responseBody != null ? responseBody.info : null;
        String id = responseBody != null && responseBody.id != null ? String.valueOf(responseBody.id) : null;
        String Signature = null;
        if (secretword != null) {
            try {
                Signature = ModuleExecutor.makeHash(secretword, ErrorCode.getCode(), ErrorDescription, amount_kop, date, externalId, info, id);
            }
            catch (BGException e) {
                throw new IOException(e);
            }
        }
        boolean WillCallback = false;
        StringBuilder out = new StringBuilder(666);
        out.append("<ServiceResponse xmlns=\"http://ruru.service.provider\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        out.append("<ErrorCode>" + ErrorCode.getCode() + "</ErrorCode>\n");
        if (ErrorDescription != null) {
            out.append("<ErrorDescription>" + ErrorDescription + "</ErrorDescription>\n");
        }
        out.append("<WillCallback>" + (WillCallback ? "true" : "false") + "</WillCallback>\n");
        if (Signature != null) {
            out.append("<Signature>" + Signature + "</Signature>\n");
        }
        if (responseBody != null) {
            out.append("<ResponseBody>\n");
            if (amount_kop != null) {
                out.append("<Amount>" + amount_kop + "</Amount>\n");
            }
            if (date != null) {
                out.append("<Date>" + date + "</Date>\n");
            }
            if (externalId != null) {
                out.append("<ExternalId>" + externalId + "</ExternalId>\n");
            }
            if (info != null) {
                out.append("<Info>" + info + "</Info>\n");
            }
            if (id != null) {
                out.append("<Id>" + id + "</Id>\n");
            }
            out.append("</ResponseBody>\n");
        }
        out.append("</ServiceResponse>");
        response.getOutputStream().write(out.toString().getBytes("UTF-8"));
        response.getOutputStream().flush();
        response.getOutputStream().close();
        this.getLogger().debug("do reply ErrorCode=" + ErrorCode.getCode());
        this.getLogger().debug(out.toString());
    }

    private RuRuPayRequest getRequest(HttpServletRequest request, String secretword) throws ParseRequestException, BGException {
        String reqsig;
        RuRuPayRequest payrequest = new RuRuPayRequest();
        String saction = request.getParameter("action");
        if (saction == null) {
            throw new ParseRequestException("missing parameter 'action' required", ReplyErrorCode.ERR_500);
        }
        payrequest.action = RuRuPayRequestAction.get(saction);
        if (payrequest.action == null) {
            throw new ParseRequestException("error value parameter 'action' : '" + saction + "'", ReplyErrorCode.ERR_500);
        }
        String sid = request.getParameter("id");
        if (sid == null) {
            throw new ParseRequestException("missing parameter 'id' required", ReplyErrorCode.ERR_102);
        }
        payrequest.id = Utils.parseInteger((String)sid, null);
        if (payrequest.id == null) {
            throw new ParseRequestException("error value parameter 'id' : '" + sid + "'", ReplyErrorCode.ERR_102);
        }
        payrequest.externalId = request.getParameter("externalId");
        if (payrequest.action == RuRuPayRequestAction.CANCELINIT) {
            String sreason = request.getParameter("reason");
            if (sreason == null) {
                throw new ParseRequestException("missing parameter 'reason' required", ReplyErrorCode.ERR_999);
            }
            payrequest.reason = (RuRuPayCancelReason)Utils.getListItemEnumFromId(RuRuPayCancelReason.class, (int)Utils.parseInt((String)sreason, (int)-1), (Enum)RuRuPayCancelReason.UNKNOWN);
            if (payrequest.reason == RuRuPayCancelReason.UNKNOWN) {
                this.getLogger().warn("unknown value parameter 'reason' : '" + sreason + "'");
            }
        }
        payrequest.code = request.getParameter("code");
        if (payrequest.code == null && payrequest.action != RuRuPayRequestAction.CANCELINIT) {
            throw new ParseRequestException("missing parameter 'code' required", ReplyErrorCode.ERR_999);
        }
        payrequest.account = request.getParameter("account");
        if (payrequest.action != RuRuPayRequestAction.CANCELINIT) {
            String samount = request.getParameter("amount");
            if (samount == null) {
                throw new ParseRequestException("missing parameter 'amount' required", ReplyErrorCode.ERR_203);
            }
            payrequest.amount_kop = Utils.parseInteger((String)samount, null);
            if (payrequest.amount_kop == null) {
                throw new ParseRequestException("error value parameter 'amount' : '" + samount + "'", ReplyErrorCode.ERR_203);
            }
        }
        if (payrequest.action != RuRuPayRequestAction.CANCELINIT) {
            String sdate = request.getParameter("date");
            if (sdate == null) {
                throw new ParseRequestException("missing parameter 'date' required", ReplyErrorCode.ERR_104);
            }
            payrequest.date = TimeUtils.parseDate((String)sdate, (String)DATE_FORMAT, (TimeZone)TZ_RURU);
            if (payrequest.date == null) {
                throw new ParseRequestException("error value parameter 'date' : '" + sdate + "'", ReplyErrorCode.ERR_104);
            }
        }
        payrequest.params = request.getParameter("params");
        payrequest.signature = request.getParameter("signature");
        if (payrequest.action == RuRuPayRequestAction.INIT) {
            if (payrequest.externalId == null && payrequest.account == null) {
                throw new ParseRequestException("missing parameter 'externalId' or 'account' in INIT-request required", ReplyErrorCode.ERR_103);
            }
        } else if (payrequest.externalId == null) {
            throw new ParseRequestException("missing parameter 'externalId' in not-INIT-request required", ReplyErrorCode.ERR_103);
        }
        if (!(reqsig = ModuleExecutor.makeHash(secretword, request.getParameter("action"), request.getParameter("id"), request.getParameter("externalId"), request.getParameter("code"), request.getParameter("account"), request.getParameter("amount"), request.getParameter("date"), request.getParameter("params"), request.getParameter("reason"))).equals(payrequest.signature)) {
            throw new ParseRequestException("error signature", ReplyErrorCode.ERR_600);
        }
        return payrequest;
    }

    public static String makeHash(String secretword, Object ... params) throws BGException {
        try {
            StringBuilder params_string = new StringBuilder(666);
            for (Object param : params) {
                if (param == null) continue;
                params_string.append(String.valueOf(param));
            }
            String decoded_key = Base64.decodeUTF8((String)secretword);
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(decoded_key.getBytes(), "HmacSHA1"));
            byte[] raw_signature = mac.doFinal(params_string.toString().getBytes());
            String encoded_signature = new String(Base64.encode((byte[])raw_signature));
            return encoded_signature;
        }
        catch (Exception e) {
            throw new BGException("error make hash", (Throwable)e);
        }
    }

    public static String generateOrder(Setup setup, int contractId) throws BGException {
        SequentialIdManager sequentialIdManager = new SequentialIdManager(setup, "rurupay");
        return String.valueOf(contractId) + "_" + String.valueOf(sequentialIdManager.generateSequentialId());
    }

    private static enum ReplyErrorCode {
        ERR_0(0),
        ERR_30(30),
        ERR_100(100),
        ERR_101(101),
        ERR_102(102),
        ERR_103(103),
        ERR_104(104),
        ERR_200(200),
        ERR_201(201),
        ERR_202(202),
        ERR_203(203),
        ERR_204(204),
        ERR_300(300),
        ERR_400(400),
        ERR_500(500),
        ERR_600(600),
        ERR_999(999);

        private int code;

        private ReplyErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static class ResponseBody {
        Integer amount_kop;
        Date date;
        String externalId;
        String info;
        Integer id;

        private ResponseBody() {
        }
    }

    private static class RuRuPayRequest {
        public RuRuPayRequestAction action;
        public Integer id;
        public String externalId;
        public RuRuPayCancelReason reason;
        public String code;
        public String account;
        public Integer amount_kop;
        public Date date;
        public String params;
        public String signature;

        private RuRuPayRequest() {
        }
    }

    private static class ParseRequestException
    extends Exception {
        private ReplyErrorCode errorCode;

        public ParseRequestException(String errorDescription, ReplyErrorCode errorCode) {
            super(errorDescription);
            this.errorCode = errorCode;
        }

        public ReplyErrorCode getErrorCode() {
            return this.errorCode;
        }
    }

    private static enum RuRuPayRequestAction {
        INIT,
        CANCELINIT,
        PAYMENT;


        public static RuRuPayRequestAction get(String action) {
            return Stream.of(RuRuPayRequestAction.values()).filter(a -> a.name().equalsIgnoreCase(action)).findFirst().orElse(null);
        }
    }
}

