/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots;

import com.sun.istack.NotNull;
import com.vk.api.sdk.objects.messages.Message;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotManagement;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.TelegramRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.VKRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.TelegramMessageBuilder;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.VKMessageBuilder;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotStatisticDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class BotSender
extends BGLogger {
    private ServerContext serverContext = (ServerContext)ServerContext.get();

    public void send(@NotNull BotMessage message) throws Exception {
        Set botManagerModuleIds = ModuleCache.getInstance().getModulesList().stream().filter(module -> module.getName().equals("botmanager")).mapToInt(Id::getId).boxed().collect(Collectors.toSet());
        this.getLogger().debug("\u041c\u043e\u0434\u0443\u043b\u0435\u0439 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 = " + botManagerModuleIds.size());
        Iterator iterator = botManagerModuleIds.iterator();
        while (iterator.hasNext()) {
            int mid = (Integer)iterator.next();
            this.getLogger().debug("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f = " + mid);
            this.send(message, mid);
        }
    }

    public void send(@NotNull BotMessage message, int moduleId) throws Exception {
        this.checkValidMessage(message);
        this.getLogger().debug("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c \u0431\u043e\u0442\u043e\u0432.");
        List<Integer> contractIds = this.getContractsForSendingMessage(message);
        for (RuntimeBot bot : this.getBotsForSendingMessage(moduleId, message)) {
            if (bot.getBotState() == 0) {
                this.getLogger().debug("\u0411\u043e\u0442 ID=" + bot.getBotId() + " \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430!");
                continue;
            }
            this.send(bot, message, contractIds);
        }
    }

    private void checkValidMessage(BotMessage message) throws BGException {
        if (message == null) {
            throw new BGException("BotMessage is null!");
        }
        if (Utils.isBlankString((String)message.text) && message.dialog == null) {
            this.getLogger().error("\u0414\u043b\u044f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0435\u043a\u0441\u0442 \u0438 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.");
            throw new BGException("\u0422\u0435\u043a\u0441\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c! \u0414\u043b\u044f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0435\u043a\u0441\u0442 \u0438 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.");
        }
    }

    private List<Integer> getContractsForSendingMessage(BotMessage message) throws Exception {
        List<Integer> contractIds = new ArrayList<Integer>();
        if (Utils.notEmptyCollection(message.contracts)) {
            contractIds.addAll(message.contracts);
        }
        if (Utils.notEmptyCollection(message.contractLabelIds)) {
            contractIds = this.filterByContractLabels(contractIds, message.contractLabelIds);
        }
        return contractIds;
    }

    private List<RuntimeBot> getBotsForSendingMessage(int moduleId, BotMessage message) throws BGException {
        ArrayList<RuntimeBot> bots = new ArrayList<RuntimeBot>(BotManagement.getOrInitAndGet(this.serverContext, moduleId).getRuntimeBotMap().values());
        if (message.botId > 0) {
            bots.removeIf(bot -> bot.getBotId() != message.botId);
            if (Utils.isEmptyCollection(bots)) {
                throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0431\u043e\u0442\u0430 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439");
            }
            this.getLogger().debug("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0431\u0443\u0434\u0443\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0431\u043e\u0442\u0430 ID=" + message.botId);
        }
        return bots;
    }

    private List<Integer> filterByContractLabels(List<Integer> cids, Set<Integer> labelIds) throws Exception {
        ArrayList<Integer> result = new ArrayList<Integer>(cids.size());
        ContractLabelService contractLabelService = (ContractLabelService)this.serverContext.getService(ContractLabelService.class, 0);
        for (Integer cid : cids) {
            if (!contractLabelService.getContractLabelIds(cid.intValue()).stream().anyMatch(labelIds::contains)) continue;
            result.add(cid);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043e \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438 \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c: " + cids.size() + " \u041c\u0435\u0442\u043e\u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438: " + labelIds.size() + " \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438: " + result.size());
        }
        return result;
    }

    private void send(RuntimeBot bot, BotMessage message, List<Integer> contractIds) throws Exception {
        Map<Long, Integer> userMessengerIds = this.getUserMessengerIds(bot, message, contractIds);
        if (userMessengerIds.size() > 0) {
            this.getLogger().info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0431\u043e\u0442\u0430 ID=" + bot.getBotId() + " \u041a\u043e\u043b-\u0432\u043e \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0435\u0439: " + userMessengerIds.size());
            BotDialog dialog = this.makeBotDialog(message);
            if (bot instanceof TelegramRuntimeBot) {
                this.sendOnTelegramBot(bot, dialog, userMessengerIds);
            } else if (bot instanceof VKRuntimeBot) {
                this.sendOnVKBot(bot, dialog, userMessengerIds);
            }
            if (bot.isStatisticEnable()) {
                ArrayList<StatisticNote> statistics = new ArrayList<StatisticNote>();
                for (Long userMessngerId : userMessengerIds.keySet()) {
                    StatisticNote statisticNote = new StatisticNote();
                    statisticNote.setBotId(bot.getBotId());
                    statisticNote.setComment("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442");
                    statisticNote.setMessengerUserId(userMessngerId.longValue());
                    statisticNote.setContractId(userMessengerIds.get(userMessngerId).intValue());
                    statisticNote.setLastMessageTime(new Date());
                    statisticNote.setLastViewedDialogId(message.dialog != null ? message.dialog.getId() : 0);
                    statistics.add(statisticNote);
                }
                this.getLogger().info("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0435 \u0434\u043b\u044f \u0431\u043e\u0442\u0430 ID=" + bot.getBotId());
                this.getLogger().info("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043e \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435: " + statistics.size());
                BotStatisticDao statisticDao = new BotStatisticDao(this.serverContext.getConnection(), bot.getModuleId());
                for (StatisticNote statisticNote : statistics) {
                    statisticDao.update(statisticNote);
                }
            }
        } else {
            this.getLogger().info("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0431\u043e\u0442\u0430 ID=" + bot.getBotId() + " \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0442.\u043a. \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f \u0432 \u0441\u043f\u0438\u0441\u043a\u0435.");
        }
    }

    private BotDialog makeBotDialog(BotMessage message) {
        BotDialog dialog = message.dialog;
        if (message.dialog == null) {
            dialog = new BotDialog();
        }
        if (Utils.notBlankString((String)message.text)) {
            BotDialogElement textElement = new BotDialogElement();
            textElement.setElementType(BotDialogElementType.TEXT);
            JSONObject config = new JSONObject();
            config.put("text", (Object)message.text);
            textElement.setConfigElement(config.toString());
            dialog.getDialogElements().add(textElement);
        }
        return dialog;
    }

    private void sendOnTelegramBot(RuntimeBot bot, BotDialog dialog, Map<Long, Integer> userMessengerIds) throws Exception {
        TelegramRuntimeBot telegramBot = (TelegramRuntimeBot)bot;
        TelegramMessageBuilder messageBuilder = new TelegramMessageBuilder(bot);
        for (Long userMessengerId : userMessengerIds.keySet()) {
            BotApiMethod<?> msg = messageBuilder.buildMessage(userMessengerId, -1, dialog);
            telegramBot.getLongPollingBot().messageNew(msg);
        }
    }

    private void sendOnVKBot(RuntimeBot bot, BotDialog dialog, Map<Long, Integer> userMessengerIds) throws Exception {
        VKRuntimeBot vkBot = (VKRuntimeBot)bot;
        VKMessageBuilder messageBuilder = new VKMessageBuilder(bot);
        for (Long messengerId : userMessengerIds.keySet()) {
            Message message = messageBuilder.buildMessage((Integer)messengerId.intValue(), dialog);
            message.setFromId(Integer.valueOf(messengerId.intValue()));
            vkBot.getApiHandler().messageNew(message);
        }
    }

    private Map<Long, Integer> getUserMessengerIds(RuntimeBot bot, BotMessage message, List<Integer> contractIds) throws Exception {
        HashMap<Long, Integer> userMessengerIds = new HashMap<Long, Integer>();
        Map<Long, Integer> sessions = bot.getBotSessions();
        for (Long userMessengerId : sessions.keySet()) {
            if (message.userIds != null && message.userIds.contains(userMessengerId)) {
                userMessengerIds.put(userMessengerId, sessions.get(userMessengerId));
            }
            if (message.contracts == null || !message.contracts.contains(sessions.get(userMessengerId))) continue;
            userMessengerIds.put(userMessengerId, sessions.get(userMessengerId));
        }
        BotStatisticDao statisticDao = new BotStatisticDao(this.serverContext.getConnection(), bot.getModuleId());
        for (StatisticNote statisticNote : statisticDao.getListByBotId(bot.getBotId())) {
            if (message.userIds == null || !message.userIds.contains(statisticNote.getMessengerUserId())) continue;
            userMessengerIds.put(statisticNote.getMessengerUserId(), statisticNote.getContractId());
        }
        if (Utils.notEmptyCollection(contractIds)) {
            for (Integer cid : contractIds) {
                for (StatisticNote statisticNote : statisticDao.getList(bot.getBotId(), cid)) {
                    userMessengerIds.put(statisticNote.getMessengerUserId(), cid);
                }
            }
        }
        return userMessengerIds;
    }

    public static final class BotMessage {
        private Set<Integer> contracts;
        private List<Long> userIds;
        private Set<Integer> contractLabelIds;
        private int botId;
        private String text;
        private BotDialog dialog;

        private BotMessage() {
        }

        public static BotMessage createMessage() {
            return new BotMessage();
        }

        public BotMessage setContracts(Set<Integer> contracts) {
            this.contracts = contracts;
            return this;
        }

        public BotMessage setContract(int contractId) {
            if (this.contracts == null) {
                this.contracts = new HashSet<Integer>();
            }
            this.contracts.add(contractId);
            return this;
        }

        public BotMessage setContractLabelIds(List<Integer> labelIds) {
            this.contractLabelIds = new HashSet<Integer>(labelIds);
            return this;
        }

        public BotMessage setUserIds(List<Long> userIds) {
            this.userIds = userIds;
            return this;
        }

        public BotMessage addUserId(long userId) {
            if (this.userIds == null) {
                this.userIds = new ArrayList<Long>();
            }
            this.userIds.add(userId);
            return this;
        }

        public BotMessage setBotId(int botid) {
            this.botId = botid;
            return this;
        }

        public BotMessage setText(String text) {
            this.text = text;
            return this;
        }

        public BotMessage setDialog(BotDialog dialog) {
            this.dialog = dialog;
            return this;
        }
    }
}

