/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CheckFiscalData {
    public Check.Type type;
    public LocalDateTime time;
    public BigDecimal total;
    public String fn;
    public String fd;
    public String fp;
    public String comment;
    public String ofd_receipt_url;
    public String ofd_inn;
    public Map<String, String> attrs = new HashMap<String, String>();
    public static final String DATE_FORMAT = "yyyyMMdd'T'HHmmss";

    public String toJson() {
        return this.toJson(0);
    }

    public String toJson(int indentFactor) {
        JSONObject jsonObject = new JSONObject();
        if (this.type != null) {
            jsonObject.put("type", (Object)this.type.toString());
        }
        jsonObject.put("time", this.time != null ? TimeUtils.format((LocalDateTime)this.time, (String)DATE_FORMAT) : null);
        jsonObject.put("total", this.total != null ? this.total.toPlainString() : null);
        jsonObject.put("fn", (Object)this.fn);
        jsonObject.put("fd", (Object)this.fd);
        jsonObject.put("fp", (Object)this.fp);
        if (this.comment != null) {
            jsonObject.put("comment", (Object)this.comment);
        }
        if (this.ofd_receipt_url != null) {
            jsonObject.put("ofd_receipt_url", (Object)this.ofd_receipt_url);
        }
        if (this.ofd_inn != null) {
            jsonObject.put("ofd_inn", (Object)this.ofd_inn);
        }
        for (Map.Entry<String, String> attr : this.attrs.entrySet()) {
            jsonObject.put("_" + attr.getKey(), (Object)attr.getValue());
        }
        return jsonObject.toString(indentFactor);
    }

    public static CheckFiscalData fromJson(String data) {
        JSONObject jsonObject = new JSONObject(data);
        CheckFiscalData cfd = new CheckFiscalData();
        cfd.type = (Check.Type)Utils.parseEnum(Check.Type.class, (String)jsonObject.optString("type", null), null);
        cfd.time = !jsonObject.isNull("time") ? TimeUtils.parseLocalDateTime((String)jsonObject.getString("time"), (String)DATE_FORMAT) : null;
        cfd.total = jsonObject.optBigDecimal("total", null);
        cfd.fn = jsonObject.optString("fn", null);
        cfd.fd = jsonObject.optString("fd", null);
        cfd.fp = jsonObject.optString("fp", null);
        cfd.comment = jsonObject.optString("comment", null);
        cfd.ofd_receipt_url = jsonObject.optString("ofd_receipt_url", null);
        cfd.ofd_inn = jsonObject.optString("ofd_inn", null);
        for (String _key : jsonObject.keySet()) {
            if (!_key.startsWith("_")) continue;
            cfd.attrs.put(_key.substring(1), jsonObject.optString(_key, null));
        }
        return cfd;
    }

    public void fillAttrs(Map<String, Object> map, String ... exceptKeys) {
        List<String> _exceptKeys = Arrays.asList(exceptKeys);
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            if (_exceptKeys.contains(key)) continue;
            Object value = e.getValue();
            this.attrs.put(key, value != null ? value.toString() : null);
        }
    }

    public void timeNow() {
        this.time = LocalDateTime.now();
    }

    public void time(Date dateTime) {
        this.time = dateTime == null ? null : dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void time(String timeString, String format) {
        this.time = timeString == null ? null : DateTimeUtils.parseLocalDateTime((String)timeString, (String)format);
    }
}

