/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.bean.condition;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.base.DispatchConditionChecker;

public class DispatchBalanceLimitConditionChecker
implements DispatchConditionChecker {
    @Override
    public boolean check(Connection con, DispatchCondition condition, Dispatch dispatch, Subscription subscribtion) throws BGException {
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal balanceLimit = BigDecimal.ZERO;
        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
            balance = balanceUtils.getBalance(LocalDate.now(), subscribtion.getContractId());
            balanceLimit = ContractDao.getContract((Connection)con, (int)subscribtion.getContractId()).getBalanceLimit();
        }
        return balance.compareTo(balanceLimit) < 0;
    }
}

