/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.config.server.service;

import jakarta.jws.WebService;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigDataDto;
import ru.bitel.bgbilling.kernel.config.common.service.ConfigService;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.config.common.service.ConfigService")
public class ConfigServiceImpl
extends AbstractService
implements ConfigService {
    @Override
    public void moduleConfigActiveSet(int moduleId, int configId) throws BGException {
        this.tryCall(() -> new ConfigDAO(this.getConnection()).setActiveModuleConfig(moduleId, configId));
        EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(moduleId, this.userId));
    }

    @Override
    public ConfigData moduleConfigActiveGet(int moduleId) throws BGException {
        return (ConfigData)((Object)this.tryReturn(() -> new ConfigDAO(this.getConnection()).getActiveConfig(moduleId)));
    }

    @Override
    public ConfigData moduleConfigGet(int configId) throws BGException {
        return (ConfigData)((Object)this.tryReturn(() -> (ConfigData)new ConfigDAO(this.getConnection()).get(configId)));
    }

    @Override
    public void moduleConfigDelete(int moduleId, int configId) throws BGException {
        this.tryCall(() -> new ConfigDAO(this.getConnection()).delete(configId));
        EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(moduleId, this.userId));
    }

    @Override
    public int moduleConfigUpdate(int moduleId, ConfigData configData) throws BGException {
        return (Integer)this.tryReturn(() -> {
            configData.setUserId(this.userId);
            new ConfigDAO(this.getConnection()).update((Object)configData);
            if (configData.isActive()) {
                EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(moduleId, this.userId));
            }
            return configData.getId();
        });
    }

    @Override
    public List<ConfigDataDto> moduleConfigList(int moduleId) throws BGException {
        return (List)this.tryReturn(() -> {
            List<ConfigData> configDataList = new ConfigDAO(this.getConnection()).list(moduleId, false);
            Directory<UserInfo> directory = this.context.getDirectory(UserInfo.class, 0);
            Iterator<ConfigData> iterator = configDataList.iterator();
            while (iterator.hasNext()) {
                ConfigData configData;
                UserInfo userInfo = directory.get((configData = iterator.next()).getUserId());
                configData.setUserName((String)(userInfo == null ? "??? [id=" + configData.getUserId() + "]" : userInfo.getName()));
            }
            return configDataList.stream().map(ConfigData::toConfigDataDto).toList();
        });
    }
}

