/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.sorm.client.ContractsWithClosedSormResourcesDialog;
import ru.bitel.bgbilling.modules.sorm.client.SormSettingsPanel;
import ru.bitel.bgbilling.modules.sorm.client.SormStatisticPanel;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;

public class SormProjectsPanel
extends BGUPanel {
    private static final String SETTINGS_PANEL = "settings";
    static final String LIST_PROJECTS_PANEL = "list_projects_panel";
    protected BGUList<SormProject> projectsList;
    private SormSettingsPanel sormSettingsPanel;
    private SormService sormService;
    private SormStatisticPanel sormStatisticPanel;
    StartUploadAsyncAction uploadWithoutPayments = new StartUploadAsyncAction(sormProject -> this.getService().startUpload(sormProject, false), "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0438\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439...");
    StartUploadAsyncAction uploadWithPayments = new StartUploadAsyncAction(sormProject -> this.getService().startUpload(sormProject, true), "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438", "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0438\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438...");
    StartUploadAsyncAction fullUploadWithPayments = new StartUploadAsyncAction(sormProject -> this.getService().startFullUpload(sormProject, true), "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438", "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438...");
    StartUploadAsyncAction fullUploadWithoutPayments = new StartUploadAsyncAction(sormProject -> this.getService().startFullUpload(sormProject, false), "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439...");
    AbstractBGUPanel.DefaultAction clearStatisticForProject = new AbstractBGUPanel.DefaultAction("", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            SormProject selectedProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (selectedProject == null) {
                return;
            }
            if (ClientUtils.confirm((String)("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \"" + selectedProject.getTitle() + "\" ?"), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438")) {
                SormProjectsPanel.this.getService().clearStatisticOfProject(selectedProject.getId(), null);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(selectedProject);
            }
        }
    };

    protected void jbInit() throws Exception {
        this.setLayout(new CardLayout());
        this.sormSettingsPanel = new SormSettingsPanel(this);
        this.sormStatisticPanel = new SormStatisticPanel();
        this.projectsList = new BGUList();
        this.projectsList.setCellRenderer((ListCellRenderer)new ProjectsListCellRenderer(this, (ClientContext)this.getContext()));
        this.projectsList.setSelectionMode(0);
        this.projectsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    SormProjectsPanel.this.performAction("edit");
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent) && SormProjectsPanel.this.projectsList.isEnabled()) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    JMenuItem addItem = new JMenuItem("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
                    addItem.addActionListener(e -> SormProjectsPanel.this.performAction("new"));
                    if (SormProjectsPanel.this.projectsList.getSelectedValue() != null) {
                        popupMenu.add((Action)((Object)SormProjectsPanel.this.uploadWithPayments));
                        popupMenu.add((Action)((Object)SormProjectsPanel.this.uploadWithoutPayments));
                        popupMenu.addSeparator();
                        popupMenu.add((Action)((Object)SormProjectsPanel.this.fullUploadWithPayments));
                        popupMenu.add((Action)((Object)SormProjectsPanel.this.fullUploadWithoutPayments));
                        popupMenu.addSeparator();
                        popupMenu.add("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0432\u044b\u0433\u0440\u0443\u0437\u043e\u043a").addActionListener(e -> SormProjectsPanel.this.tryCall(() -> SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject((SormProject)SormProjectsPanel.this.projectsList.getSelectedValue())));
                        popupMenu.add((Action)SormProjectsPanel.this.clearStatisticForProject);
                        popupMenu.addSeparator();
                        popupMenu.add("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430").addActionListener(e -> SormProjectsPanel.this.tryCall(() -> new ContractsWithClosedSormResourcesDialog(SormProjectsPanel.this.getService(), (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue())));
                        popupMenu.addSeparator();
                        popupMenu.add("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043f\u0440\u043e\u0435\u043a\u0442\u0430").addActionListener(e -> SormProjectsPanel.this.showConfig());
                        popupMenu.addSeparator();
                        popupMenu.add(addItem);
                        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> SormProjectsPanel.this.performAction("edit"));
                        popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> SormProjectsPanel.this.performAction("delete"));
                    } else {
                        popupMenu.add(addItem);
                    }
                    popupMenu.show(SormProjectsPanel.this.projectsList.getParent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)new JScrollPane((Component)this.projectsList), (Component)((Object)this.sormStatisticPanel), 200L), LIST_PROJECTS_PANEL);
        this.add((Component)((Object)this.sormSettingsPanel), SETTINGS_PANEL);
        this.showPanel(LIST_PROJECTS_PANEL);
    }

    void showPanel(String titlePanel) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show((Container)((Object)this), titlePanel);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List projects = ((SormService)((ClientContext)this.getContext()).getPort(SormService.class)).getSormProjects();
            this.projectsList.setData(projects);
            if (Utils.notEmptyCollection((Collection)projects)) {
                this.sormStatisticPanel.loadStatisticOfProject((SormProject)projects.get(0));
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.showPanel(SETTINGS_PANEL);
            this.sormSettingsPanel.performAction("new");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.projectsList.getSelectedValue() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            this.sormSettingsPanel.setSormProject((SormProject)this.projectsList.getSelectedValue());
            this.sormSettingsPanel.performAction("refresh");
            this.showPanel(SETTINGS_PANEL);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            SormProject selectedProject = (SormProject)this.projectsList.getSelectedValue();
            if (selectedProject == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)selectedProject.getTitle())) {
                this.getService().deleteSormProject(selectedProject.getId());
                this.sormSettingsPanel.performAction("refresh");
                this.performAction("refresh");
            }
        });
    }

    private void showConfig() {
        SormProject selectedProject = (SormProject)this.projectsList.getSelectedValue();
        if (selectedProject == null) {
            return;
        }
        Preferences preferences = new Preferences();
        preferences.loadData(selectedProject.getConfig(), "\n");
        preferences.set("sorm.ftp.password", "******");
        String config = preferences.toString();
        JTextArea configText = new JTextArea();
        configText.setLineWrap(true);
        configText.setEditable(false);
        configText.setText(config);
        Dimension size = new Dimension(500, 400);
        JScrollPane scrollPane = new JScrollPane(configText);
        scrollPane.setPreferredSize(size);
        scrollPane.setMinimumSize(size);
        scrollPane.setMaximumSize(size);
        JOptionPane.showMessageDialog(null, scrollPane, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 " + selectedProject.getTitle(), -1);
    }

    private SormService getService() {
        if (this.sormService == null) {
            this.sormService = (SormService)((ClientContext)this.getContext()).getPort(SormService.class);
        }
        return this.sormService;
    }

    private final class StartUploadAsyncAction
    extends AbstractBGUPanel.AsyncAction<Window> {
        private final UploadInBackgroundImpl uploadInBackground;
        private final String waitWindowsDescription;

        public StartUploadAsyncAction(UploadInBackgroundImpl uploadInBackground, String comboboxItemName, String waitWindowsDescription) {
            super((AbstractBGUPanel)SormProjectsPanel.this, "", comboboxItemName);
            this.uploadInBackground = uploadInBackground;
            this.waitWindowsDescription = waitWindowsDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Window doInBackground() throws Exception {
            SormProject sormProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (!sormProject.isEnable()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                return null;
            }
            Window waitWindow = ClientUtils.showWaitWindow((String)this.waitWindowsDescription);
            try {
                this.uploadInBackground.startUpload(sormProject);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(sormProject);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
            finally {
                waitWindow.dispose();
            }
            return waitWindow;
        }

        protected void done(Window window) throws Exception {
            if (window != null) {
                window.dispose();
            }
        }
    }

    private static interface UploadInBackgroundImpl {
        public void startUpload(SormProject var1) throws Exception;
    }

    private final class ProjectsListCellRenderer
    implements ListCellRenderer<SormProject> {
        private final Font font = new Font("Dialog", 0, 15);
        private Directory<UserInfo> userDirectory;

        ProjectsListCellRenderer(SormProjectsPanel sormProjectsPanel, ClientContext clientContext) {
            try {
                this.userDirectory = clientContext.getDirectory(UserInfo.class, 0);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SormProject> jList, SormProject sormProject, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel title = new JLabel("\u041f\u0440\u043e\u0435\u043a\u0442: " + sormProject.getTitle());
            title.setFont(new Font("Monospaced", 1, 15));
            UserInfo userInfo = null;
            try {
                userInfo = (UserInfo)this.userDirectory.get(sormProject.getUserId());
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            JLabel projectType = new JLabel("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a: " + SormManufacturer.getType((int)sormProject.getProjectType()).getGuiTitle());
            projectType.setFont(this.font);
            JLabel createDate = new JLabel("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f: " + TimeUtils.format((Date)sormProject.getCreateDate(), (String)"dd.MM.yyyy"));
            createDate.setFont(this.font);
            JLabel lastModifyDate = new JLabel("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f: " + TimeUtils.format((Date)sormProject.getLastModifyDate(), (String)"dd.MM.yyyy"));
            lastModifyDate.setFont(this.font);
            JLabel user = new JLabel((String)(userInfo != null ? "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0434\u0435\u043b\u0430\u043b: " + userInfo.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>"));
            user.setFont(this.font);
            String projectComment = sormProject.getComment();
            JLabel comment = new JLabel((String)(Utils.notBlankString((String)projectComment) ? "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: " + projectComment : ""));
            comment.setFont(this.font);
            JPanel renderedPanel = new JPanel(new GridBagLayout());
            renderedPanel.setBackground(isSelected ? jList.getSelectionBackground() : jList.getBackground());
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
            renderedPanel.add((Component)title, constraints);
            renderedPanel.add((Component)projectType, constraints);
            renderedPanel.add((Component)comment, constraints);
            renderedPanel.add((Component)createDate, constraints);
            renderedPanel.add((Component)lastModifyDate, constraints);
            renderedPanel.add((Component)user, constraints);
            return renderedPanel;
        }
    }
}

