/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.HistoryKeepPeriodType;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryRequest;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryUserConfig;
import ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlHistoryService;
import ru.bitel.bgbilling.plugins.sqleditor.server.bean.SqlHistoryDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlHistoryService")
public class SqlHistoryServiceImpl
extends AbstractService
implements SqlHistoryService {
    private SqlHistoryDao sqlHistoryDao;

    @PostConstruct
    public void init() {
        this.sqlHistoryDao = new SqlHistoryDao(this.getConnection());
    }

    public SqlHistoryUserConfig getHistoryUserConfig() throws BGException {
        return this.sqlHistoryDao.getHistoryUserConfig(this.userId);
    }

    public void updateHistoryUserConfig(SqlHistoryUserConfig historyUserConfig) throws BGException {
        if (historyUserConfig != null && historyUserConfig.getUserId() <= 0) {
            historyUserConfig.setUserId(this.userId);
        }
        this.sqlHistoryDao.updateHistoryUserConfig(historyUserConfig);
    }

    public SearchResult<SqlHistoryRequest> getUserRequestList(Page page) throws BGException {
        this.deleteOldRequests();
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(this.sqlHistoryDao.getRequestListByUser(this.userId, page));
        return searchResult;
    }

    public void updateSqlHistoryRequest(SqlHistoryRequest historyRequest) throws BGException {
        if (historyRequest.getUserId() <= 0) {
            historyRequest.setUserId(this.userId);
        }
        if (historyRequest.getCreateDate() == null) {
            historyRequest.setCreateDate(new Date());
        }
        this.sqlHistoryDao.updateRequest(historyRequest);
    }

    public int deleteOldRequests() throws BGException {
        SqlHistoryUserConfig historyUserConfig = this.sqlHistoryDao.getHistoryUserConfig(this.userId);
        if (historyUserConfig == null || historyUserConfig.getKeepPeriod() == null) {
            return 0;
        }
        if (historyUserConfig.getKeepPeriod().equals((Object)HistoryKeepPeriodType.ALL_TIME)) {
            return 0;
        }
        List<Integer> requestListIdsForDelete = this.sqlHistoryDao.getRequestListByUser(this.userId, null).stream().filter(this.mustDeleted(historyUserConfig)).mapToInt(Id::getId).boxed().collect(Collectors.toList());
        this.sqlHistoryDao.deleteRequests(requestListIdsForDelete);
        return requestListIdsForDelete.size();
    }

    private Predicate<SqlHistoryRequest> mustDeleted(SqlHistoryUserConfig historyUserConfig) {
        return request -> {
            Date requestDate = request.getCreateDate();
            LocalDateTime requestLocalDateTime = TimeUtils.convertDateToLocalDateTime((Date)requestDate);
            LocalDateTime now = LocalDateTime.now();
            if (historyUserConfig.getKeepPeriod().equals((Object)HistoryKeepPeriodType.MONTH)) {
                int daysCountInMonth = TimeUtils.convertDateToCalendar((Date)requestDate).getActualMaximum(5);
                return ChronoUnit.DAYS.between(requestLocalDateTime, now) > (long)daysCountInMonth;
            }
            if (historyUserConfig.getKeepPeriod().equals((Object)HistoryKeepPeriodType.WEEK)) {
                return ChronoUnit.DAYS.between(requestLocalDateTime, now) > 7L;
            }
            return false;
        };
    }

    public void deleteByQueryInfo(Date requestDate, String query) throws BGException {
        this.sqlHistoryDao.deleteByQueryInfo(requestDate, query);
    }
}

