/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.common.bean;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentType;
import ru.bitel.common.Utils;

public class ContragentInfos {
    public String address;
    public ContragentType type;
    public String title;
    public String titleFull;
    public String inn;
    public String kpp;
    public String snils;
    public String f;
    public String i;
    public String o;
    public List<ContragentInfo> ids = new ArrayList<ContragentInfo>();

    public String toString() {
        return this.title + " (" + this.inn + ")";
    }

    public String toStringFull() {
        String full = (String)(this.type != null ? "[" + this.type.name + "] " : "") + this.titleFull + " (" + this.inn + ")";
        if (Utils.notBlankString((String)this.address)) {
            full = full + "\n" + this.address;
        }
        return full;
    }

    public String toStringFullId() {
        String info = this.toStringFull() + "\n\n";
        info = this.ids.isEmpty() ? info + "[\u041e\u0428\u0418\u0411\u041a\u0410 \u0418\u0414]" : info + this.ids.get(0).toString();
        return info;
    }

    public static ContragentInfos fromJson(String info) throws BGException {
        if (Utils.isBlankString((String)info)) {
            return null;
        }
        ContragentInfos infos = new ContragentInfos();
        try {
            JSONObject json = new JSONObject(info);
            infos.address = json.optString("address", null);
            String _type = json.optString("type", null);
            infos.type = (ContragentType)Utils.parseEnum(ContragentType.class, (String)_type, null);
            infos.title = json.optString("title", null);
            infos.titleFull = json.optString("titleFull", null);
            infos.inn = json.optString("inn", null);
            infos.kpp = json.optString("kpp", null);
            infos.snils = json.optString("snils", null);
            infos.f = json.optString("f", null);
            infos.i = json.optString("i", null);
            infos.o = json.optString("o", null);
            JSONArray idsarray = json.optJSONArray("ids");
            if (idsarray != null) {
                for (int index = 0; index < idsarray.length(); ++index) {
                    JSONObject iditem = idsarray.getJSONObject(index);
                    ContragentInfo id = new ContragentInfo();
                    id.id = iditem.optString("id", null);
                    id.operatorId = iditem.optString("operatorId", null);
                    id.operatorName = iditem.optString("operatorName", null);
                    id.main = iditem.optBoolean("main", false);
                    id.roaming = iditem.optBoolean("roaming", false);
                    id.ok = iditem.optBoolean("ok", false);
                    infos.ids.add(id);
                }
            }
        }
        catch (Exception e) {
            throw new BGException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 ContragentInfos \u0438\u0437 \u0411\u0414 (" + e.toString() + ")", (Throwable)e);
        }
        return infos;
    }

    public String toJson() {
        JSONObject json = new JSONObject();
        json.put("address", (Object)this.address);
        json.put("type", (Object)this.type.name());
        json.put("title", (Object)this.title);
        json.put("titleFull", (Object)this.titleFull);
        json.put("inn", (Object)this.inn);
        json.put("kpp", (Object)this.kpp);
        json.put("snils", (Object)this.snils);
        json.put("f", (Object)this.f);
        json.put("i", (Object)this.i);
        json.put("o", (Object)this.o);
        JSONArray idsarray = new JSONArray();
        for (ContragentInfo id : this.ids) {
            JSONObject iditem = new JSONObject();
            iditem.put("id", (Object)id.id);
            iditem.put("operatorId", (Object)id.operatorId);
            iditem.put("operatorName", (Object)id.operatorName);
            iditem.put("main", id.main);
            iditem.put("roaming", id.roaming);
            iditem.put("ok", id.ok);
            idsarray.put((Object)iditem);
        }
        json.put("ids", (Object)idsarray);
        return json.toString();
    }

    public static class ContragentInfo {
        public String id;
        public String operatorId;
        public String operatorName;
        public boolean main;
        public boolean roaming;
        public boolean ok;

        public String toString() {
            String title = this.operatorName + " (" + this.id + ")";
            if (this.main) {
                title = title + " [\u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439]";
            }
            if (this.roaming) {
                title = title + " [\u0440\u043e\u0443\u043c\u0438\u043d\u0433]";
            }
            if (!this.ok) {
                title = title + " [\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b]";
            }
            return title;
        }
    }
}

