/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionPeriodType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class SoftlineProductDao
extends AbstractIdDao<SoftLineProduct> {
    public SoftlineProductDao(Connection con, int moduleId) {
        this(con, "softline_product", moduleId);
    }

    private SoftlineProductDao(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
    }

    protected SoftLineProduct getFromRS(ResultSet rs) throws SQLException {
        SoftLineProduct product = new SoftLineProduct();
        product.setId(rs.getInt("id"));
        product.setTitle(rs.getString("title"));
        product.setDescription(rs.getString("description"));
        product.setSoftLineCode(rs.getString("softLineCode"));
        product.setPrice(rs.getBigDecimal("price"));
        product.setServiceId(rs.getInt("serviceId"));
        product.setPeriodType(SoftLineSubscriptionPeriodType.valueOf((int)rs.getInt("periodType")));
        product.setAmountOfDays(rs.getInt("periodCount"));
        product.setProductCategoryId(rs.getInt("product_category_id"));
        return product;
    }

    protected void updateImpl(SoftLineProduct product) throws SQLException {
        String querySet = "title=?, description=?, softLineCode=?, price=?, serviceId=?, periodType=?, periodCount=?, product_category_id=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)product, querySet);){
            int index = 1;
            ps.setString(index++, product.getTitle());
            ps.setString(index++, product.getDescription());
            ps.setString(index++, product.getSoftLineCode());
            ps.setBigDecimal(index++, product.getPrice());
            ps.setInt(index++, product.getServiceId());
            ps.setInt(index++, product.getPeriodType().getCode());
            ps.setInt(index++, product.getAmountOfDays());
            ps.setInt(index++, product.getProductCategoryId());
            this.executeUpdate((Id)product, index, ps);
        }
    }

    public List<SoftLineProduct> getProducts(SearchResult<SoftLineProduct> searchResult) throws SQLException {
        List result = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + Page.toSqlLimit((Page)page);
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
        }
        return result;
    }

    public List<SoftLineProduct> getProductsOfCategory(int productCategoryId) throws SQLException {
        ArrayList<SoftLineProduct> result = new ArrayList<SoftLineProduct>();
        String query = "SELECT * FROM " + this.tableName + " WHERE product_category_id=" + productCategoryId;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        return result;
    }
}

